/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.internal.core.model;

import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrResource;
import org.vcs.bazaar.eclipse.internal.core.model.BzrObject;

public abstract class BzrBranch
extends BzrObject
implements IBzrBranch {
    private static final long serialVersionUID = 2L;
    protected final BranchLocation location;

    public abstract URI getLocation();

    public abstract IPath getPath();

    public BzrBranch(BranchLocation location) {
        this.location = location;
    }

    public boolean isBound() {
        return false;
    }

    public BranchLocation getBranchLocation() {
        return this.location;
    }

    public boolean equals(Object otherRepo) {
        if (!(otherRepo instanceof IBzrBranch)) {
            return false;
        }
        return ((IBzrBranch)otherRepo).getBranchLocation().equals((Object)this.getBranchLocation());
    }

    public int hashCode() {
        return this.getBranchLocation().hashCode();
    }

    public int compareTo(IBzrBranch otherRepo) {
        return otherRepo.getBranchLocation().compareTo(this.getBranchLocation());
    }

    public boolean isProjectBranch() {
        return false;
    }

    public IBzrBranch getBranch() {
        return this;
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public String getBranchRelativePathAsString() {
        return this.getLocation().toString();
    }

    public String getName() {
        return this.getNick();
    }

    public boolean isFolder() {
        return false;
    }

    public String getRelativePath(IBzrResource ancestor) {
        return this.getLocation().relativize(ancestor.getLocation()).toString();
    }

    public IBzrBranch getParent() {
        return null;
    }
}

