/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.internal.core.model;

import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;

public class BzrResourceStatus
implements IBzrResourceStatus {
    private final IBazaarStatus status;
    private final IBzrLocalResource resource;

    public BzrResourceStatus(IBzrLocalResource resource, IBazaarStatus status) {
        this.resource = resource;
        this.status = status;
    }

    public IBzrLocalResource getResource() {
        return this.resource;
    }

    public boolean contains(BazaarStatusKind kind) {
        return this.status.contains(kind);
    }

    public IBazaarStatus getStatus() {
        return this.status;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BzrResourceStatus other = (BzrResourceStatus)obj;
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals((Object)other.status));
    }

    public boolean isAdded() {
        return this.contains(BazaarStatusKind.CREATED);
    }

    public boolean isDeleted() {
        return this.contains(BazaarStatusKind.DELETED);
    }

    public boolean isKindChange() {
        return this.contains(BazaarStatusKind.KIND_CHANGED);
    }

    public boolean isHasConflicts() {
        return this.contains(BazaarStatusKind.HAS_CONFLICTS);
    }

    public boolean isModified() {
        return this.contains(BazaarStatusKind.MODIFIED);
    }

    public boolean isPendingMerge() {
        return this.contains(BazaarStatusKind.PENDING_MERGE);
    }

    public boolean isRenamed() {
        return this.contains(BazaarStatusKind.RENAMED);
    }

    public boolean isUnchanged() {
        return this.contains(BazaarStatusKind.UNCHANGED);
    }

    public boolean isUnknown() {
        return this.contains(BazaarStatusKind.UNKNOWN);
    }

    public boolean isUnversioned() {
        return this.contains(BazaarStatusKind.UNVERSIONED);
    }

    public boolean isVersioned() {
        return this.contains(BazaarStatusKind.VERSIONED);
    }

    public boolean isXBitChanged() {
        return this.contains(BazaarStatusKind.X_BIT_CHANGED);
    }

    public boolean isIgnored() {
        return this.contains(BazaarStatusKind.IGNORED);
    }

    public boolean isAnyModifiedStatus() {
        return this.isHasConflicts() || this.isKindChange() || this.isModified() || this.isRenamed() || this.isUnknown() || this.isXBitChanged() || this.isAdded() || this.isDeleted();
    }
}

