/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.internal.core.model;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrMissingRevisions;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.internal.core.model.BzrBranch;
import org.vcs.bazaar.eclipse.internal.core.model.BzrMissingRevisions;

public class LocalBranch
extends BzrBranch
implements IBzrLocalBranch {
    private static final long serialVersionUID = 1L;

    public LocalBranch(BranchLocation location) {
        super(location);
        assert ("file".equals(location.getScheme()));
    }

    public boolean isLocal() {
        return true;
    }

    public IProject getProject() {
        return null;
    }

    public URI getLocation() {
        return this.location.getUri();
    }

    public File getFile() {
        return this.getPath().toFile();
    }

    public IPath getPath() {
        return new Path(this.location.getRaw());
    }

    public String getNick() {
        try {
            IBazaarClient client = EclipseBazaarCore.getDefault().createClient();
            client.setWorkDir(this.getFile());
            return client.nick(null);
        }
        catch (BazaarException e) {
            throw BazaarException.makeUnChecked((CoreException)((Object)e));
        }
        catch (BazaarClientException e) {
            throw BazaarClientException.makeUnChecked((Exception)((Object)e));
        }
    }

    public IBzrBranch getParent() {
        IBazaarInfo info = null;
        if (info == null) {
            info = this.getInfo();
        }
        if (info == null || info.getRelatedBranches() == null || info.getRelatedBranches().getParentBranch() == null) {
            return null;
        }
        return BranchFactory.findOrCreateFor(info.getRelatedBranches().getParentBranch());
    }

    public IBzrBranch getPushBranch() {
        IBazaarInfo info = null;
        if (info == null) {
            info = this.getInfo();
        }
        if (info == null || info.getRelatedBranches() == null) {
            return null;
        }
        if (info.getRelatedBranches().getPushBranch() != null && !"".equals(info.getRelatedBranches().getPushBranch().trim())) {
            return BranchFactory.findOrCreateFor(info.getRelatedBranches().getPushBranch());
        }
        return null;
    }

    public IBazaarInfo getInfo() {
        try {
            IBazaarClient client = EclipseBazaarCore.getDefault().createClient();
            client.setWorkDir(this.getFile());
            return client.info(this.getFile(), new Option[0]);
        }
        catch (BazaarException e) {
            throw BazaarException.makeUnChecked((CoreException)((Object)e));
        }
        catch (BazaarClientException e) {
            throw BazaarClientException.makeUnChecked((Exception)((Object)e));
        }
    }

    public boolean isBound() {
        IBazaarInfo info = this.getInfo();
        if (info == null) {
            return false;
        }
        IBazaarInfo.Locations locations = info.getLocations();
        return locations.getCheckoutOfBranch() != null || locations.getCheckoutRoot() != null || locations.getLightCheckoutRoot() != null || locations.getBoundToBranch() != null || locations.getRepositoryCheckoutRoot() != null;
    }

    public IBzrMissingRevisions getMissing(IBzrBranch otherBranch) throws BazaarException {
        return new BzrMissingRevisions(new HashMap<String, List<IBazaarLogMessage>>());
    }

    public BranchLocation getPushLocation() {
        IBzrBranch pushBranch = this.getPushBranch();
        if (pushBranch != null) {
            return pushBranch.getBranchLocation();
        }
        return null;
    }
}

