/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.internal.core.model;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.InfoCommand;
import org.vcs.bazaar.eclipse.core.commands.NickCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrMissingRevisions;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.internal.core.model.BzrMissingRevisions;
import org.vcs.bazaar.eclipse.internal.core.model.LocalBranch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBranch
extends LocalBranch {
    private static final long serialVersionUID = 1L;
    private IBazaarInfo info;
    private String nick;
    private boolean dirty = true;
    private boolean dirtyNick = true;

    public ProjectBranch(BranchLocation location) {
        super(location);
        assert ("file".equals(this.getLocation().getScheme()));
    }

    @Override
    public String getNick() {
        try {
            if (this.nick == null || this.dirtyNick) {
                NickCommand cmd = new NickCommand(this);
                cmd.run((IProgressMonitor)new NullProgressMonitor());
                this.nick = cmd.getNick();
                this.dirtyNick = false;
            }
        }
        catch (BazaarException e) {
            EclipseBazaarCore.log(e.getMessage(), (Throwable)((Object)e));
            this.nick = null;
        }
        return this.nick;
    }

    @Override
    public IBazaarInfo getInfo() {
        try {
            if (this.info == null || this.dirty) {
                InfoCommand cmd = new InfoCommand(this, false);
                cmd.run((IProgressMonitor)new NullProgressMonitor());
                this.info = cmd.getInfo();
                this.dirty = false;
            }
        }
        catch (BazaarException e) {
            EclipseBazaarCore.log(e.getMessage(), (Throwable)((Object)e));
            this.info = null;
        }
        return this.info;
    }

    @Override
    public IBzrMissingRevisions getMissing(IBzrBranch otherBranch) throws BazaarException {
        return new BzrMissingRevisions(this.calculateMissing(otherBranch));
    }

    protected Map<String, List<IBazaarLogMessage>> calculateMissing(IBzrBranch otherBranch) throws BazaarException {
        Map result = null;
        IBazaarClient client = null;
        try {
            client = BzrWorkspaceRoot.getClient(this, true);
            result = client.missing(this.getFile(), otherBranch.getBranchLocation(), new Option[0]);
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        return result;
    }

    @Override
    public boolean isProjectBranch() {
        return true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.dirtyNick = dirty;
    }
}

