/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.internal.core.model.local;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.RepositoryProvider;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IRemoveOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.BzrStatus;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrResource;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.internal.core.model.BzrResource;
import org.vcs.bazaar.eclipse.internal.core.model.local.BzrLocalFolder;

public abstract class BzrLocalResource
extends BzrResource
implements IBzrLocalResource {
    private final IResource resource;

    protected BzrLocalResource(IResource resource, IBzrBranch branch) {
        super(branch);
        this.resource = resource;
    }

    public boolean exists() {
        return this.getIResource().exists();
    }

    public boolean isFolder() {
        return false;
    }

    public IResource getIResource() {
        return this.resource;
    }

    public IBzrResource getParent() {
        IContainer parent = this.resource.getParent();
        if (parent != null && parent.getType() == 2) {
            return new BzrLocalFolder((IFolder)parent, this.getBranch());
        }
        return null;
    }

    public IPath getBranchRelativePath() {
        IPath location = this.resource.getLocation();
        IPath branchPath = this.getBranch().getPath();
        Assert.isTrue((boolean)branchPath.isPrefixOf(location));
        IPath tail = location.removeFirstSegments(branchPath.segmentCount());
        Path result = new Path("/");
        int i = 0;
        while (i < tail.segmentCount()) {
            result = result.append(tail.segment(i));
            ++i;
        }
        return result.makeRelative();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDirty() {
        boolean result = false;
        if (!(this instanceof IContainer)) {
            if (!(this.resource instanceof IFile)) return result;
            BzrStatus status = this.getStatus();
            if (status == null) return false;
            if (!status.isAnyModifiedStatus()) return false;
            return true;
        }
        try {
            IResource[] ress = ((IContainer)this.resource).members();
            int i = 0;
            while (!result) {
                if (i >= ress.length) {
                    return result;
                }
                result = BzrWorkspaceRoot.getBzrResourceFor(ress[i]).isDirty();
                if (result) {
                    return result;
                }
                ++i;
            }
            return result;
        }
        catch (CoreException cex) {
            String msg = "Problem checking dirty state";
            EclipseBazaarCore.log(msg, cex);
            return result;
        }
    }

    public void delete() throws BazaarException {
        try {
            this.getBzrWorkspaceRoot().getClient().remove(new File[]{this.getIResource().getLocation().toFile()}, new Option[]{IRemoveOptions.NO_BACKUP});
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e, this.getIResource());
        }
    }

    public BzrWorkspaceRoot getBzrWorkspaceRoot() {
        BazaarTeamProvider provider = (BazaarTeamProvider)RepositoryProvider.getProvider((IProject)this.resource.getProject(), (String)EclipseBazaarCore.getProviderID());
        if (provider == null) {
            return null;
        }
        return provider.getBzrWorkspaceRoot();
    }

    public void move(IPath destination) throws BazaarException {
        try {
            this.getBzrWorkspaceRoot().getClient().move(this.getIResource().getLocation().toFile(), destination.toFile(), new Option[0]);
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e, this.getIResource());
        }
    }

    public boolean isManaged() throws BazaarException {
        if (this.isProjectAndBranchRoot()) {
            return true;
        }
        BzrStatus status = this.getStatus();
        return status != null && !status.isUnknown() && !status.isIgnored() && !status.isUnversioned();
    }

    private boolean isProjectAndBranchRoot() {
        return this.getIResource().getType() == 4 && this.getBranch().getPath().isPrefixOf(this.getIResource().getLocation());
    }

    public void unmanage(IProgressMonitor monitor) throws BazaarException {
        try {
            this.getBzrWorkspaceRoot().getClient().remove(new File[]{this.getIResource().getLocation().toFile()}, new Option[]{IRemoveOptions.KEEP});
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e, this.getIResource());
        }
    }

    public File getFile() {
        return this.getIResource().getLocation().toFile();
    }

    public boolean isProject() {
        return this.getIResource().getType() == 4;
    }

    public URI getLocation() {
        return this.getIResource().getLocationURI();
    }

    public String getName() {
        return this.getIResource().getName();
    }

    public BzrStatus getStatus() {
        return EclipseBazaarCore.getDefault().getStatusCacheManager().getStatus(this.getIResource());
    }

    public int hashCode() {
        return this.getIResource().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof IBzrLocalResource) {
            IBzrLocalResource bzrRes = (IBzrLocalResource)obj;
            return this.getIResource().equals((Object)bzrRes.getIResource()) && this.getBranch().equals(bzrRes.getBranch());
        }
        return super.equals(obj);
    }
}

