/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.vcs.bazaar.client.IBazaarPromptUserPassword;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.notifications.NotificationListener;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.console.BzrOutputConsole;
import org.vcs.bazaar.eclipse.ui.credentials.BazaarCredentialsProvider;
import org.vcs.bazaar.eclipse.ui.notifications.BazaarNotificationListener;
import org.vcs.bazaar.eclipse.ui.team.BazaarUtilities;
import org.vcs.bazaar.eclipse.ui.team.RefreshExecutionListener;

public class EclipseBazaarUI
extends AbstractUIPlugin {
    private static EclipseBazaarUI plugin;
    private BzrOutputConsole console;
    private BundleListener bundleListener;
    private RefreshExecutionListener refreshExecListener;

    public EclipseBazaarUI() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle() == EclipseBazaarUI.this.getBundle() && event.getType() == 2 && EclipseBazaarUI.this.getBundle().getState() == 32) {
                    try {
                        String version = (String)EclipseBazaarUI.this.getBundle().getHeaders().get(UITexts.Dependency_Version);
                        if (version != null && !version.equals(EclipseBazaarUI.this.getPreferenceStore().getString(UITexts.Dependency_Version))) {
                            EclipseBazaarUI.this.getPreferenceStore().setValue(UITexts.Dependency_Version, version);
                        }
                        EclipseBazaarCore.getDefault().checkClient();
                    }
                    catch (BazaarException bazaarException) {
                        EclipseBazaarUI.getStandardDisplay().asyncExec(new Runnable(){

                            public void run() {
                                BazaarUtilities.configureExecutable();
                            }
                        });
                    }
                }
            }
        };
        context.addBundleListener(this.bundleListener);
        super.start(context);
        this.refreshExecListener = new RefreshExecutionListener();
        this.refreshExecListener.addTo((ICommandService)this.getWorkbench().getService(ICommandService.class));
        EclipseBazaarCore.getDefault().setCredentialsProvider((IBazaarPromptUserPassword)new BazaarCredentialsProvider());
        EclipseBazaarCore.getDefault().getStatusCacheManager().setLogCacheEnabled(this.getPreferenceStore().getBoolean("pref_file_text_decorator_enabled"));
        this.console = new BzrOutputConsole();
        EclipseBazaarCore.getDefault().setNotificationListener((NotificationListener)new BazaarNotificationListener());
    }

    public void stop(BundleContext context) throws Exception {
        this.refreshExecListener.removeFrom((ICommandService)this.getWorkbench().getService(ICommandService.class));
        this.getConsole().shutdown();
        context.removeBundleListener(this.bundleListener);
        super.stop(context);
        plugin = null;
    }

    public static EclipseBazaarUI getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return EclipseBazaarUI.getDefault().getBundle().getSymbolicName();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)EclipseBazaarUI.getPluginId(), (String)path);
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = EclipseBazaarUI.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static void runWithProgress(Shell parent, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        boolean createdShell = false;
        try {
            if (parent == null || parent.isDisposed()) {
                Display display = EclipseBazaarUI.getStandardDisplay();
                if (display == null) {
                    runnable.run((IProgressMonitor)new NullProgressMonitor());
                    return;
                }
                parent = display.getActiveShell();
                if (parent == null) {
                    parent = new Shell(display);
                    createdShell = true;
                }
            }
            final Exception[] holder = new Exception[1];
            BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        runnable.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (InvocationTargetException e) {
                        holder[0] = e;
                    }
                    catch (InterruptedException e) {
                        holder[0] = e;
                    }
                }
            });
            if (holder[0] != null) {
                if (holder[0] instanceof InvocationTargetException) {
                    throw (InvocationTargetException)holder[0];
                }
                throw (InterruptedException)holder[0];
            }
        }
        finally {
            if (createdShell && parent != null) {
                parent.dispose();
            }
        }
    }

    public static void log(String message, int severity) {
        Status status = new Status(severity, EclipseBazaarUI.getPluginId(), 0, message, null);
        EclipseBazaarUI.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message, CoreException ex) {
        Status status = new Status(ex.getStatus().getSeverity(), EclipseBazaarUI.getPluginId(), ex.getStatus().getCode(), message, (Throwable)ex);
        EclipseBazaarUI.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message, Throwable thr) {
        Status status = new Status(4, EclipseBazaarUI.getPluginId(), 0, message, thr);
        EclipseBazaarUI.getDefault().getLog().log((IStatus)status);
    }

    public static void log(CoreException ex) {
        EclipseBazaarUI.getDefault().getLog().log(ex.getStatus());
    }

    public static void log(Throwable t) {
        EclipseBazaarUI.log(t.getMessage(), t);
    }

    public static boolean isTracing(String optionId) {
        String option = String.valueOf(EclipseBazaarUI.getPluginId()) + "/trace/" + optionId;
        String value = Platform.getDebugOption((String)option);
        return "true".equals(value);
    }

    public static void traceException(String optionId, Exception ex) {
        if (EclipseBazaarUI.isTracing(optionId)) {
            ex.printStackTrace();
        }
    }

    public static Color getInfoBgColor() {
        return EclipseBazaarUI.getStandardDisplay().getSystemColor(29);
    }

    public static Color getBgColor() {
        return EclipseBazaarUI.getStandardDisplay().getSystemColor(25);
    }

    public static Display getStandardDisplay() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public synchronized BzrOutputConsole getConsole() {
        return this.console;
    }
}

