/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.vcs.bazaar.client.IBazaarStatus;

public class UIUtils {
    public static void addBulbDecorator(Control control, String tooltip) {
        ControlDecoration dec = new ControlDecoration(control, 16512);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        dec.setShowOnlyOnFocus(true);
        dec.setShowHover(true);
        dec.setDescriptionText(tooltip);
    }

    public static Font getFont(String id) {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get(id);
    }

    public static ImageDescriptor getEditorImage(IBazaarStatus status) {
        if (status.isDirectory()) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        return UIUtils.getEditorImage(status.getPath());
    }

    public static ImageDescriptor getEditorImage(String path) {
        String name;
        if (path != null && path.length() > 0 && (name = new Path(path).lastSegment()) != null) {
            return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(name);
        }
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
    }

    public static String getFirstLine(String text) {
        int nlIndex = text.indexOf(10);
        if (nlIndex > 0) {
            text = text.substring(0, nlIndex);
        }
        return text;
    }

    public static void addSizeLimiter(final TableColumn column) {
        if (column != null) {
            column.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    if (column.getWidth() < 5) {
                        column.setWidth(5);
                    }
                }

                public void controlMoved(ControlEvent e) {
                }
            });
        }
    }

    public static void addSizeLimiter(final TreeColumn column) {
        if (column != null) {
            column.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    if (column.getWidth() < 5) {
                        column.setWidth(5);
                    }
                }

                public void controlMoved(ControlEvent e) {
                }
            });
        }
    }
}

