/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.BazaarRevisionRange;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.commands.StatusCommand;
import org.vcs.bazaar.eclipse.core.history.BazaarFileRevision;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.resources.IStorageBazaarRevision;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.compare.CompareUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompareAction
extends BaseSelectionListenerAction {
    protected AbstractCompareAction(String text) {
        super(text);
    }

    public void run() {
        this.internalRun();
    }

    protected abstract void internalRun();

    protected boolean updateSelection(IStructuredSelection selection) {
        return this.shouldShow(selection);
    }

    protected abstract boolean shouldShow(IStructuredSelection var1);

    protected BazaarFileRevision getRevision(int selectionIdx) throws CoreException {
        IStructuredSelection selection = this.getStructuredSelection();
        Object[] revs = selection.toArray();
        if (selectionIdx >= revs.length) {
            return null;
        }
        return (BazaarFileRevision)revs[selectionIdx];
    }

    protected IStorageBazaarRevision getStorage(int selectionIdx) throws CoreException {
        IStructuredSelection selection = this.getStructuredSelection();
        Object[] revs = selection.toArray();
        if (selectionIdx >= revs.length) {
            return null;
        }
        FileRevision rev = (FileRevision)revs[selectionIdx];
        return (IStorageBazaarRevision)rev.getStorage(null);
    }

    protected void openEditor(IBzrBranch branch, BazaarRevision revision) throws BazaarException {
        IProject[] projects = BzrWorkspaceRoot.findProjectsInBranch((IBzrBranch)branch);
        this.openEditor((IResource[])projects, revision);
    }

    protected void openEditor(IResource resource, BazaarRevision revision) throws BazaarException {
        this.openEditor(new IResource[]{resource}, revision);
    }

    protected void openEditor(IBzrBranch branch, BazaarRevision startRevision, BazaarRevision endRevision) throws BazaarException {
        IProject[] projects = BzrWorkspaceRoot.findProjectsInBranch((IBzrBranch)branch);
        this.openEditor((IResource[])projects, startRevision, endRevision);
    }

    protected void openEditor(IResource resource, BazaarRevision startRevision, BazaarRevision endRevision) throws BazaarException {
        this.openEditor(new IResource[]{resource}, startRevision, endRevision);
    }

    protected void openEditor(IResource[] resources, BazaarRevision revision) throws BazaarException {
        CompareUtils.openStructuredCompareEditor(resources, AbstractCompareAction.getStatus(resources, (IBazaarRevisionSpec)revision), null, revision, null);
    }

    protected void openEditor(IResource[] resources, BazaarRevision startRevision, BazaarRevision endRevision) throws BazaarException {
        CompareUtils.openStructuredCompareEditor(resources, AbstractCompareAction.getStatus(resources, (IBazaarRevisionSpec)BazaarRevisionRange.getRange((BazaarRevision)startRevision, (BazaarRevision)endRevision)), endRevision, startRevision, null);
    }

    public static List<IBzrResourceStatus> getStatus(IResource[] resources, IBazaarRevisionSpec revision) throws BazaarException {
        IBzrLocalResource[] bzrResources = BzrWorkspaceRoot.getBzrResourcesFor((IResource[])resources);
        StatusCommand cmd = new StatusCommand(bzrResources, revision);
        cmd.run((IProgressMonitor)new NullProgressMonitor());
        return Arrays.asList(cmd.getStatus());
    }
}

