/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalFile;
import org.vcs.bazaar.eclipse.core.utils.BzrJobStatus;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.annotaions.ShowAnnotationOperation;

public class AnnotateAction
extends WorkbenchAction {
    public void execute(IAction action) throws BazaarException {
        Shell shell = this.getParentShell();
        IResource resource = this.getSelectedResources()[0];
        if (resource instanceof IFile) {
            final IBzrLocalFile file = BzrWorkspaceRoot.getBzrFileFor((IResource)resource);
            final IWorkbenchPart activePart = this.getActivePage().getActivePart();
            Job job = new Job("Getting annotations"){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            new ShowAnnotationOperation(activePart, file).run(monitor);
                        }
                        catch (InvocationTargetException e) {
                            EclipseBazaarUI.log(e.getMessage(), e);
                            IStatus iStatus = UIJob.errorStatus((Throwable)e);
                            monitor.done();
                            return iStatus;
                        }
                        catch (InterruptedException e) {
                            EclipseBazaarUI.log(e.getMessage(), e);
                            IStatus iStatus = UIJob.errorStatus((Throwable)e);
                            monitor.done();
                            return iStatus;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return BzrJobStatus.OK_STATUS;
                }
            };
            job.setUser(true);
            job.setPriority(50);
            job.schedule();
        } else {
            MessageDialog.openInformation((Shell)shell, (String)("Bazaar Eclipse Annotate " + resource.getLocation().toString()), (String)CoreTexts.Command_not_implemented);
        }
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }
}

