/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.internal.core.model.ProjectBranch;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.internal.TeamAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BzrAction
extends TeamAction {
    protected IAction action = null;

    public final void run(IAction action) {
        try {
            if (!this.needEnablementCheck().booleanValue() && !this.isEnabled()) {
                this.handle((Exception)((Object)new BazaarException(this.getStatusNotEnabled(action))), UITexts.BzrAction_errorTitle, "The selected action cannot be executed");
            } else {
                if (!this.beginExecution(action)) {
                    return;
                }
                this.execute(action);
            }
        }
        catch (Exception e) {
            this.handle(e);
        }
    }

    private IStatus getStatusNotEnabled(IAction action) {
        return new Status(4, EclipseBazaarUI.getPluginId(), String.valueOf(action.getText()) + " is not enabled in this context", null);
    }

    protected abstract void execute(IAction var1) throws Exception;

    @Override
    protected void setActionEnablement(IAction action) {
        if (this.needEnablementCheck().booleanValue()) {
            super.setActionEnablement(action);
        } else {
            action.setEnabled(true);
        }
    }

    private Boolean needEnablementCheck() {
        IPreferenceStore prefStore = EclipseBazaarUI.getDefault().getPreferenceStore();
        Boolean checkEnablement = prefStore.getBoolean("pref_performance_check_action_availability");
        return checkEnablement == null ? true : checkEnablement;
    }

    protected final void run(final IRunnableWithProgress runnable, boolean cancelable, int progressKind) throws InvocationTargetException, InterruptedException {
        final Exception[] exceptions = new Exception[1];
        final IRunnableWithProgress innerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                runnable.run(monitor);
            }
        };
        switch (progressKind) {
            case 2: {
                Display display = EclipseBazaarUI.getStandardDisplay();
                BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                    public void run() {
                        try {
                            innerRunnable.run((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (InvocationTargetException e) {
                            exceptions[0] = e;
                        }
                        catch (InterruptedException e) {
                            exceptions[0] = e;
                        }
                    }
                });
                break;
            }
            default: {
                new ProgressMonitorDialog(this.getShell()).run(true, cancelable, innerRunnable);
            }
        }
        if (exceptions[0] != null) {
            if (exceptions[0] instanceof InvocationTargetException) {
                throw (InvocationTargetException)exceptions[0];
            }
            throw (InterruptedException)exceptions[0];
        }
    }

    protected IResource[] getSelectedResources(int type) {
        HashSet<IResource> resources = new HashSet<IResource>();
        IResource[] iResourceArray = this.getSelectedResources();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == type) {
                resources.add(resource);
            }
            ++n2;
        }
        return resources.toArray(new IResource[0]);
    }

    protected IProject[] getEnclosingProjectsForSelectedResources() {
        HashSet<IProject> list = new HashSet<IProject>();
        IProject[] iProjectArray = this.getSelectedProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            list.add(project);
            ++n2;
        }
        iProjectArray = this.getSelectedResources();
        n = iProjectArray.length;
        n2 = 0;
        while (n2 < n) {
            IProject resource = iProjectArray[n2];
            if (resource.getType() != 4) {
                list.add(resource.getProject());
            }
            ++n2;
        }
        return list.toArray(new IProject[0]);
    }

    protected static final Map<IBzrBranch, List<IResource>> getFilesByBranchMap(IResource[] resources) {
        HashMap<IBzrBranch, List<IResource>> map = new HashMap<IBzrBranch, List<IResource>>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ProjectBranch branch = BranchFactory.findOrCreateFor((IProject)resource.getProject());
            ArrayList<IResource> list = (ArrayList<IResource>)map.get(branch);
            if (list == null) {
                list = new ArrayList<IResource>();
                map.put((IBzrBranch)branch, list);
            }
            list.add(resource);
            ++n2;
        }
        return map;
    }

    protected void handle(Exception exception) {
        if (exception != null) {
            if (!(exception instanceof InvocationTargetException)) {
                EclipseBazaarUI.log(exception.getMessage(), exception);
            }
            this.handle(exception, UITexts.BzrAction_errorTitle, exception.getLocalizedMessage());
        }
    }

    public void init(IAction action) {
        super.init(action);
        this.action = action;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.action = null;
    }

    protected IAction getAction() {
        return this.action;
    }

    protected boolean isSameBranchInEnclosingProjects() {
        IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        IBzrLocalBranch branch = null;
        boolean sameBranch = false;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            BzrWorkspaceRoot root = BzrWorkspaceRoot.getBzrWorkspaceRootFor((IProject)project);
            if (root != null) {
                if (branch == null) {
                    branch = root.getBranch();
                } else {
                    sameBranch = branch.equals((Object)root.getBranch());
                    if (!sameBranch) {
                        return sameBranch;
                    }
                }
            }
            ++n2;
        }
        return sameBranch;
    }

    protected boolean beginExecution(IAction action) {
        return !this.isAnyEditorDirty() || this.saveAllEditors();
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    private boolean isAnyEditorDirty() {
        IResource[] selectedResources;
        if (this.needsToSaveDirtyEditors() && (selectedResources = this.getSelectedResources()) != null && selectedResources.length > 0) {
            IEditorReference[] editorReferences;
            IEditorReference[] iEditorReferenceArray = editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if (editorReference.isDirty()) {
                    try {
                        IFile file;
                        IEditorInput editorInput = editorReference.getEditorInput();
                        if (editorInput instanceof IFileEditorInput && this.isSelectedResource(file = ((IFileEditorInput)editorInput).getFile(), selectedResources)) {
                            return true;
                        }
                    }
                    catch (PartInitException partInitException) {}
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isSelectedResource(IFile file, IResource[] selectedResources) {
        if (file != null) {
            IFile parent = file;
            while (parent != null) {
                IResource[] iResourceArray = selectedResources;
                int n = selectedResources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource selectedResource = iResourceArray[n2];
                    if (selectedResource.equals((Object)parent)) {
                        return true;
                    }
                    ++n2;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    private boolean saveAllEditors() {
        final AtomicBoolean okToContinue = new AtomicBoolean(true);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                okToContinue.set(PlatformUI.getWorkbench().saveAllEditors(true));
            }
        });
        return okToContinue.get();
    }
}

