/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.CommitCommand;
import org.vcs.bazaar.eclipse.core.commands.StatusCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.utils.BzrJobStatus;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.PushAction;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.CommitDialog;
import org.vcs.bazaar.eclipse.ui.operations.AddOperation;
import org.vcs.bazaar.eclipse.ui.operations.PushOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitAction
extends WorkbenchAction {
    @Override
    public void execute(IAction action) throws BazaarException, InvocationTargetException, InterruptedException {
        IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor((IProject)projects[0]);
        BranchLocation pushLocation = branch.getPushLocation();
        final CommitDialog commitDialog = new CommitDialog(this.getShell(), pushLocation);
        UIJob job = new UIJob(this.getShell().getDisplay(), "Getting commitable resources..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask("Getting commitable resources..", 100);
                try {
                    CommitableResources resourceStauses = CommitAction.createCommitableResources(monitor, (IResource[])CommitAction.this.getEnclosingProjectsForSelectedResources());
                    CommitableResources selectedResource = CommitAction.createCommitableResources(monitor, CommitAction.this.getSelectedResources());
                    monitor.worked(100);
                    if (resourceStauses.getAllStatuses().isEmpty()) {
                        IStatus iStatus = BzrJobStatus.INFO((Job)this, (String)UITexts.CommitAction_nothingToCommit);
                        return iStatus;
                    }
                    for (IBzrResourceStatus status : resourceStauses.getAllStatuses()) {
                        if (!status.isHasConflicts()) continue;
                        IStatus iStatus = BzrJobStatus.INFO((Job)this, (String)UITexts.CommitAction_resolveConflicts);
                        return iStatus;
                    }
                    ArrayList<CommitableResources> results = new ArrayList<CommitableResources>(2);
                    results.add(resourceStauses);
                    results.add(selectedResource);
                    BzrJobStatus bzrJobStatus = new BzrJobStatus(0, (Job)this, results, "Commitable resources calculated");
                    return bzrJobStatus;
                }
                catch (Exception e) {
                    IStatus iStatus = UIJob.errorStatus((Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                if (status instanceof BzrJobStatus) {
                    List result;
                    int exit;
                    if (status.getSeverity() == 1) {
                        MessageDialog.openInformation((Shell)CommitAction.this.getParentShell(), (String)UITexts.Dialog_informationTitle, (String)status.getMessage());
                    } else if (status.getSeverity() == 0 && (exit = commitDialog.open((CommitableResources)(result = (List)((BzrJobStatus)status).getResult()).get(0), (CommitableResources)result.get(1), true)) == 0 && commitDialog.getCommitMessage() != null) {
                        try {
                            CommitAction.this.handleSelected((CommitableResources)result.get(0), commitDialog);
                        }
                        catch (Exception e) {
                            CommitAction.this.handle(e);
                        }
                    }
                }
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
            }
        });
        job.schedule();
    }

    protected static List<IBzrResourceStatus> getCommitableResources(IProgressMonitor monitor, IResource[] resources) throws BazaarException {
        return CommitAction.createCommitableResources(monitor, resources).getAllStatuses();
    }

    static CommitableResources createCommitableResources(IProgressMonitor monitor, IResource[] resources) throws BazaarException {
        CommitableResources commitableResource = new CommitableResources();
        IBzrLocalResource[] bzrResources = null;
        bzrResources = BzrWorkspaceRoot.getBzrResourcesFor((IResource[])resources);
        StatusCommand cmd = new StatusCommand(bzrResources, true);
        cmd.run(monitor);
        IBzrResourceStatus[] result = cmd.getStatus();
        if (result.length > 0) {
            commitableResource.add(Arrays.asList(result));
        }
        commitableResource.addPendingMerge(cmd.getPendingMerges());
        return commitableResource;
    }

    private void handleSelected(final CommitableResources commitableResources, CommitDialog commitDialog) throws BazaarException, InvocationTargetException, InterruptedException {
        final List<IResource> filesToAdd = CommitAction.getUnknownResources(commitDialog.getSelectedFiles());
        final List<IBzrLocalResource> filesToCommit = CommitAction.getResources(commitDialog.getSelectedFiles());
        final String commitText = commitDialog.getCommitMessage();
        final boolean pushAfterCommit = commitDialog.isPushAfterCommit();
        final Option[] options = commitDialog.getOptions().toArray(new Option[0]);
        final boolean fullRefresh = !CommitAction.getUnknownOrAddedResources(commitDialog.getSelectedFiles()).isEmpty();
        Job job = new Job("Running commit"){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        int work = (filesToAdd != null && filesToAdd.size() > 0 ? 1000 : 0) + (filesToCommit != null && filesToCommit.size() > 0 ? 1000 : 0) + (pushAfterCommit && filesToCommit != null && filesToCommit.size() > 0 ? 1000 : 0);
                        monitor.beginTask(CoreTexts.CommitCommand_commit, work);
                        if (!filesToAdd.isEmpty()) {
                            new AddOperation(filesToAdd.toArray(new IResource[0]), true).run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                        }
                        if (filesToCommit != null && filesToCommit.size() > 0) {
                            CommitCommand commitCmd = null;
                            commitCmd = commitableResources.getAllPendingMerges().size() > 0 ? new CommitCommand(filesToCommit, commitText, true, true, options) : new CommitCommand(filesToCommit, commitText, false, fullRefresh, options);
                            commitCmd.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                        }
                        if (pushAfterCommit && filesToCommit != null && filesToCommit.size() > 0) {
                            final IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor((IProject)((IBzrLocalResource)filesToCommit.get(0)).getIResource().getProject());
                            BranchLocation remoteLocation = branch.getPushLocation();
                            if (remoteLocation != null) {
                                new PushOperation((IBzrBranch)branch, remoteLocation, false, false, false).run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                            } else {
                                EclipseBazaarUI.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

                                    public void run() {
                                        PushAction action = new PushAction();
                                        try {
                                            action.execute((IBzrBranch)branch);
                                        }
                                        catch (BazaarException bazaarException) {
                                        }
                                        catch (InvocationTargetException invocationTargetException) {
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                });
                            }
                        }
                    }
                    catch (CoreException e) {
                        EclipseBazaarUI.log(e.getMessage(), e);
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                    catch (Exception e) {
                        EclipseBazaarUI.log(e.getMessage(), e);
                        IJobStatus iJobStatus = BzrJobStatus.ERROR((Job)this, (Throwable)e, (String)"Error while executing commit");
                        monitor.done();
                        return iJobStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return BzrJobStatus.OK((Job)this, (Object)filesToCommit, (String)"New revision committed");
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
    }

    @Override
    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommitableResources {
        List<IBazaarLogMessage> pendingMerges = new ArrayList<IBazaarLogMessage>();
        List<IBzrResourceStatus> statuses = new ArrayList<IBzrResourceStatus>();

        public void addPendingMerge(List<IBazaarLogMessage> pendingMerges) {
            this.pendingMerges.addAll(pendingMerges);
        }

        public void add(List<IBzrResourceStatus> resourceStatus) {
            this.statuses.addAll(resourceStatus);
        }

        public List<IBzrResourceStatus> getAllStatuses() {
            return this.statuses;
        }

        public List<IBazaarLogMessage> getAllPendingMerges() {
            return this.pendingMerges;
        }
    }
}

