/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.vcs.bazaar.eclipse.core.utils.BzrJobStatus;
import org.vcs.bazaar.eclipse.ui.actions.CommitAction;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.wizards.patch.CreatePatchWizard;

public class CreatePatchAction
extends WorkbenchAction {
    protected void execute(IAction action) throws Exception {
        UIJob job = new UIJob(this.getShell().getDisplay(), "Getting changed resources..."){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask("Getting changed resources..", 100);
                try {
                    CommitAction.CommitableResources resourceStauses = CommitAction.createCommitableResources(monitor, (IResource[])CreatePatchAction.this.getEnclosingProjectsForSelectedResources());
                    CommitAction.CommitableResources selectedResource = CommitAction.createCommitableResources(monitor, CreatePatchAction.this.getSelectedResources());
                    monitor.worked(100);
                    if (resourceStauses.getAllStatuses().isEmpty()) {
                        IStatus iStatus = BzrJobStatus.INFO((Job)this, (String)"No differences found");
                        return iStatus;
                    }
                    ArrayList<CommitAction.CommitableResources> results = new ArrayList<CommitAction.CommitableResources>(2);
                    results.add(resourceStauses);
                    results.add(selectedResource);
                    BzrJobStatus bzrJobStatus = new BzrJobStatus(0, (Job)this, results, "Changed resources calculated");
                    return bzrJobStatus;
                }
                catch (Exception e) {
                    IStatus iStatus = UIJob.errorStatus((Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                if (status instanceof BzrJobStatus) {
                    if (status.getSeverity() == 1) {
                        MessageDialog.openInformation((Shell)CreatePatchAction.this.getParentShell(), (String)"Information", (String)status.getMessage());
                    } else if (status.getSeverity() == 0) {
                        List result = (List)((BzrJobStatus)status).getResult();
                        CreatePatchWizard wizard = new CreatePatchWizard(((CommitAction.CommitableResources)result.get(0)).getAllStatuses(), ((CommitAction.CommitableResources)result.get(1)).getAllStatuses());
                        WizardDialog dialog = new WizardDialog(CreatePatchAction.this.getShell(), (IWizard)wizard);
                        dialog.setMinimumPageSize(700, 400);
                        dialog.setHelpAvailable(false);
                        dialog.open();
                    }
                }
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
            }
        });
        job.schedule();
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }
}

