/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.resources.IStorageBazaarRevision;
import org.vcs.bazaar.eclipse.ui.actions.CommitAction;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.compare.CompareUtils;

public class DiffAction
extends WorkbenchAction {
    public void execute(IAction action) {
        try {
            IResource[] resources = this.getSelectedResources();
            if (resources != null) {
                if (resources.length == 1 && resources[0] instanceof IFile) {
                    CompareUtils.openSaveableEditor(resources[0], new IStorageBazaarRevision(resources[0]), this.getActivePage());
                } else {
                    List<IBzrResourceStatus> commiteableResources = CommitAction.getCommitableResources((IProgressMonitor)new NullProgressMonitor(), resources);
                    CompareUtils.openStructuredCompareEditor(resources, commiteableResources, null, null, this.getActivePage());
                }
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)"An unexpected error ocurred", (String)e.getMessage());
        }
    }

    protected boolean isEnabledForMultipleResources() {
        return true;
    }

    protected boolean isEnabledByType(IResource resource) {
        return resource.getType() == 1 || resource.getType() == 2 || resource.getType() == 4;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForUnmodifiedResources() {
        return false;
    }
}

