/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.WorkspaceAction;
import org.vcs.bazaar.eclipse.ui.decorator.BazaarLightweightDecorator;

public class DisconnectAction
extends WorkspaceAction {
    protected void execute(IAction action) throws BazaarException, InvocationTargetException, InterruptedException {
        boolean ok;
        IProject[] projects = this.getSelectedProjects();
        if (projects.length > 0 && (ok = MessageDialog.openQuestion((Shell)this.getShell(), (String)UITexts.DisconnectConfirmDialog_title, (String)MessageFormat.format(UITexts.DisconnectConfirmDialog_body, projects[0].getName())))) {
            try {
                BazaarTeamProvider.unmap((IProject)projects[0]);
                BazaarLightweightDecorator.refresh();
            }
            catch (CoreException e) {
                EclipseBazaarUI.log(e.getMessage(), e);
                throw BazaarException.wrapException((CoreException)e);
            }
        }
    }

    protected boolean isEnabled() throws TeamException {
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 0) {
            return false;
        }
        if (!this.isEnabledForMultipleResources() && resources.length != 1) {
            return false;
        }
        return this.isEnabledForMultipleEclosingProjects() || this.getEnclosingProjectsForSelectedResources().length == 1;
    }

    protected boolean isEnabledByType(IResource resource) {
        return resource.getType() == 4;
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return false;
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }
}

