/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.InitCommand;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.decorator.BazaarLightweightDecorator;

public class InitAction
extends WorkbenchAction {
    private IPath bzrPath;
    private IProject project;

    public InitAction(IPath bzrPath, IProject project, Shell shell) {
        this.bzrPath = bzrPath;
        this.project = project;
        this.getShell().setParent((Composite)shell);
    }

    protected void execute(IAction action) throws BazaarException, InvocationTargetException, InterruptedException {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask("", 1000);
                        monitor.setTaskName(CoreTexts.InitCommand_taskName);
                        InitCommand op = new InitCommand(InitAction.this.bzrPath, InitAction.this.project);
                        op.run(monitor);
                    }
                    catch (BazaarException e) {
                        EclipseBazaarUI.log(e.getMessage(), (CoreException)((Object)e));
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, false, 1);
        BazaarLightweightDecorator.refresh();
    }

    protected boolean isEnabled() throws TeamException {
        if (!EclipseBazaarCore.getDefault().isClientAvailable()) {
            return false;
        }
        return !BazaarTeamProvider.isShared((IProject)this.project);
    }
}

