/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.progress.UIJob;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.model.IBzrResource;
import org.vcs.bazaar.eclipse.core.utils.BzrJobStatus;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.history.BazaarHistoryPageInput;

public class LogAction
extends WorkbenchAction {
    public void execute(IAction action) {
        UIJob job = this.createJob();
        job.setUser(true);
        job.setPriority(40);
        job.schedule();
    }

    private UIJob createJob() {
        return new UIJob(this.getShell().getDisplay(), "Fetching revision history"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask("fetching...", 100);
                IProject[] selectedProjects = LogAction.this.getSelectedProjects();
                Object resource = selectedProjects.length > 1 ? BzrWorkspaceRoot.getBranchFor((IProject)selectedProjects[0]) : BzrWorkspaceRoot.getBzrResourceFor((IResource)LogAction.this.getSelectedResources()[0]);
                try {
                    monitor.subTask("fetching resource revisions");
                    monitor.worked(20);
                    TeamUI.getHistoryView().showHistoryFor((Object)new BazaarHistoryPageInput((IBzrResource)resource, LogAction.this.getSelectedResources()));
                    IStatus iStatus = BzrJobStatus.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    EclipseBazaarUI.log(e.getMessage(), e);
                    IStatus iStatus = UIJob.errorStatus((Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
    }

    protected boolean isEnabledForMultipleResources() {
        return true;
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }

    protected boolean isEnabledForMultipleProjectsOnly() {
        return true;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledByType(IResource resource) {
        return resource.getType() == 1 || resource.getType() == 4 || resource.getType() == 2;
    }
}

