/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.MergeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.MergeDialog;

public class MergeAction
extends WorkbenchAction {
    protected void execute(IAction anAction) throws BazaarException, InvocationTargetException, InterruptedException {
        MergeDialog.MergeDialogInfo dialogInfo;
        IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor((IProject)projects[0]);
        BranchLocation remoteLocation = this.getRemoteLocation((IBzrBranch)branch, dialogInfo = new MergeDialog.MergeDialogInfo());
        if (remoteLocation != null) {
            String message = null;
            try {
                this.run((IRunnableWithProgress)new WorkspaceModifyOperation((IBzrBranch)branch, remoteLocation, dialogInfo){
                    private final /* synthetic */ IBzrBranch val$branch;
                    private final /* synthetic */ BranchLocation val$remoteLocation;
                    private final /* synthetic */ MergeDialog.MergeDialogInfo val$dialogInfo;
                    {
                        this.val$branch = iBzrBranch;
                        this.val$remoteLocation = branchLocation;
                        this.val$dialogInfo = mergeDialogInfo;
                    }

                    public void execute(IProgressMonitor monitor) throws InvocationTargetException, BazaarException {
                        try {
                            monitor.beginTask("", 1000);
                            monitor.setTaskName(CoreTexts.MergeCommand_taskName);
                            MergeCommand cmd = new MergeCommand(this.val$branch, this.val$remoteLocation, this.val$dialogInfo.getOptions().toArray(new Option[0]));
                            cmd.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }, false, 1);
            }
            catch (InvocationTargetException e) {
                message = this.handleConflicts(e);
            }
            if (message != null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)UITexts.Dialog_informationTitle, (String)message);
            }
        }
    }

    private BranchLocation getRemoteLocation(IBzrBranch branch, MergeDialog.MergeDialogInfo dialogInfo) throws BazaarException {
        Collection<IBzrBranch> locations = this.getAllBranchLocations(branch);
        IBzrBranch initialBranch = null;
        if (branch instanceof IBzrLocalBranch) {
            initialBranch = ((IBzrLocalBranch)branch).getParent();
        }
        MergeDialog dialog = new MergeDialog(this.getShell(), locations, initialBranch, dialogInfo);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            try {
                return new BranchLocation(dialogInfo.getLocation());
            }
            catch (BazaarClientException bazaarClientException) {}
        }
        return null;
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }
}

