/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrMissingRevisions;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.core.utils.BzrJobStatus;
import org.vcs.bazaar.eclipse.core.utils.BzrTeamStatus;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.LocationInputDialog;
import org.vcs.bazaar.eclipse.ui.views.MissingView;

public class MissingAction
extends WorkbenchAction {
    public void execute(IAction action) {
        IResource resource = this.getSelectedResources()[0];
        IBzrBranch otherLocation = null;
        try {
            otherLocation = this.getRemoteLocation(resource.getProject());
        }
        catch (BazaarException bazaarException) {
            MessageDialog.openError((Shell)this.getParentShell(), (String)"An unexpected error occurred", (String)"An Error ocurred when retrieving branch locations");
        }
        if (otherLocation == null) {
            return;
        }
        final IBzrLocalBranch localBranch = BzrWorkspaceRoot.getBzrWorkspaceRootFor((IProject)resource.getProject()).getBranch();
        try {
            IWorkbenchPage activePage = EclipseBazaarUI.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart viewPart = null;
            viewPart = activePage.showView("org.vcs.bazaar.eclipse.ui.views.MissingView");
            final MissingView missingView = (MissingView)viewPart;
            final IBzrBranch finalOtherLocation = otherLocation;
            Job fetchMissingJob = new Job("Calculating missing/extra revisions..."){

                public IStatus run(IProgressMonitor monitor) {
                    IBzrMissingRevisions missingRevs = null;
                    try {
                        missingRevs = localBranch.getMissing(finalOtherLocation);
                    }
                    catch (BazaarException e) {
                        EclipseBazaarUI.log((CoreException)((Object)e));
                        return new BzrTeamStatus(4, "Error while calculating revisions", (Throwable)e);
                    }
                    return BzrJobStatus.OK((Job)this, (Object)missingRevs, (String)"ok");
                }
            };
            fetchMissingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    final IStatus status = event.getResult();
                    if (status.isOK() && status instanceof BzrJobStatus) {
                        MissingAction.this.getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                missingView.setInput(((BzrJobStatus)status).getResult());
                            }
                        });
                    }
                    super.done(event);
                }
            });
            fetchMissingJob.setPriority(30);
            fetchMissingJob.setUser(true);
            fetchMissingJob.schedule();
        }
        catch (PartInitException e) {
            EclipseBazaarUI.getDefault().getLog().log(e.getStatus());
            this.handle((Exception)((Object)e));
        }
    }

    private IBzrBranch getRemoteLocation(IProject project) throws BazaarException {
        ArrayList<IBzrBranch> locations = new ArrayList<IBzrBranch>();
        IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor((IProject)project);
        IBzrBranch parent = null;
        if (branch.isLocal() && (parent = branch.getParent()) != null) {
            locations.add(parent);
        }
        LocationInputDialog.LocationDialogInfo dialogInfo = new LocationInputDialog.LocationDialogInfo();
        LocationInputDialog dialog = LocationInputDialog.missingLocationDialog(this.getShell(), locations, dialogInfo);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            if ("".equals(dialogInfo.getLocation()) && parent != null) {
                return parent;
            }
            return BranchFactory.findOrCreateFor((String)dialogInfo.getLocation());
        }
        return null;
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledByType(IResource resource) {
        return resource.getType() == 4;
    }
}

