/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IProgressService;

public class OpenBazaarRevisionAction
extends BaseSelectionListenerAction {
    protected IStructuredSelection selection;
    private final IWorkbenchSite site;

    public OpenBazaarRevisionAction(String text, IWorkbenchSite site) {
        super(text);
        this.site = site;
    }

    public void run() {
        Object[] objArray;
        IStructuredSelection structSel = this.selection;
        Object[] objectArray = objArray = structSel.toArray();
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object tempRevision = objectArray[n2];
            final IFileRevision revision = (IFileRevision)tempRevision;
            if (revision == null || !revision.exists()) {
                MessageDialog.openError((Shell)this.site.getShell(), (String)"Deleted Revision", (String)"Can't open a deleted revision");
            } else {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IStorage file = revision.getStorage(monitor);
                            String id = OpenBazaarRevisionAction.this.getEditorID(file.getName(), file.getContents());
                            if (file instanceof IFile) {
                                IDE.openEditor((IWorkbenchPage)OpenBazaarRevisionAction.this.site.getPage(), (IFile)((IFile)file));
                            } else if (this.showEditor(revision)) {
                                OpenBazaarRevisionAction.this.site.getPage().openEditor((IEditorInput)new BazaarRevisionEditorInput(revision), id);
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }

                    private boolean showEditor(IFileRevision revision2) {
                        return true;
                    }
                };
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                try {
                    progressService.run(false, false, runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
            ++n2;
        }
    }

    String getEditorID(String fileName, InputStream contents) {
        IEditorDescriptor descriptor;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IContentType type = null;
        if (contents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
            }
            catch (IOException iOException) {}
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        String id = (descriptor = registry.getDefaultEditor(fileName, type)) == null || descriptor.isOpenExternal() ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        return id;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        return this.shouldShow();
    }

    protected boolean shouldShow() {
        Object[] objArray = this.selection.toArray();
        if (objArray.length == 0) {
            return false;
        }
        Object[] objectArray = objArray;
        int n = objArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IFileRevision revision = (IFileRevision)element;
            if (revision != null && !revision.exists()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public class BazaarRevisionEditorInput
    extends PlatformObject
    implements IWorkbenchAdapter,
    IStorageEditorInput {
        private IFileRevision fileRevision;
        private IStorage storage;

        public BazaarRevisionEditorInput(IFileRevision revision) {
            this.fileRevision = revision;
            try {
                this.storage = revision.getStorage((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {}
        }

        public Object[] getChildren(Object o) {
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return this.getName();
        }

        public Object getParent(Object o) {
            return null;
        }

        public IStorage getStorage() throws CoreException {
            return this.storage;
        }

        public boolean exists() {
            return true;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return String.valueOf(new Path(this.fileRevision.getName()).lastSegment()) + " " + this.fileRevision.getContentIdentifier();
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            return String.valueOf(this.fileRevision.getName()) + " " + this.fileRevision.getContentIdentifier();
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IWorkbenchAdapter.class) {
                return this;
            }
            if (adapter == IFileRevision.class) {
                return this.fileRevision;
            }
            if (adapter == IStorage.class) {
                return this.storage;
            }
            return super.getAdapter(adapter);
        }

        public int hashCode() {
            return this.fileRevision.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BazaarRevisionEditorInput) {
                return ((BazaarRevisionEditorInput)((Object)obj)).fileRevision.equals(this.fileRevision);
            }
            return false;
        }
    }
}

