/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.PullCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.LocationInputDialog;

public class PullAction
extends WorkbenchAction {
    protected void execute(IAction action) throws BazaarException, InvocationTargetException, InterruptedException {
        IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor((IProject)projects[0]);
        LocationInputDialog.LocationDialogInfo dialogInfo = this.getRemoteLocation((IBzrBranch)branch);
        if (dialogInfo != null && dialogInfo.getLocation() != null && !"".equals(dialogInfo.getLocation().trim())) {
            String message = null;
            try {
                final BranchLocation remoteLocation = new BranchLocation(dialogInfo.getLocation());
                this.run((IRunnableWithProgress)new WorkspaceModifyOperation((IBzrBranch)branch, dialogInfo){
                    private final /* synthetic */ IBzrBranch val$branch;
                    private final /* synthetic */ LocationInputDialog.LocationDialogInfo val$dialogInfo;
                    {
                        this.val$branch = iBzrBranch;
                        this.val$dialogInfo = locationDialogInfo;
                    }

                    public void execute(IProgressMonitor monitor) throws InvocationTargetException, BazaarException {
                        try {
                            monitor.beginTask("", 1000);
                            monitor.setTaskName(CoreTexts.bind((String)CoreTexts.PullCommand_taskName, (Object)remoteLocation.toString()));
                            PullCommand cmd = new PullCommand(this.val$branch, remoteLocation);
                            cmd.setRemember(this.val$dialogInfo.isRemember());
                            cmd.setOverwrite(this.val$dialogInfo.isOverwrite());
                            cmd.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }, false, 1);
            }
            catch (InvocationTargetException ite) {
                message = this.handleConflicts(ite);
            }
            catch (BazaarClientException e) {
                EclipseBazaarUI.log(e.getMessage(), e);
                throw new InvocationTargetException(e, e.getMessage());
            }
            if (message != null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)UITexts.Dialog_informationTitle, (String)message);
            }
        }
    }

    private LocationInputDialog.LocationDialogInfo getRemoteLocation(IBzrBranch branch) throws BazaarException {
        LocationInputDialog.LocationDialogInfo dialogInfo = new LocationInputDialog.LocationDialogInfo();
        Collection<IBzrBranch> locations = this.getAllBranchLocations(branch);
        IBzrBranch initialBranch = null;
        if (branch instanceof IBzrLocalBranch) {
            initialBranch = ((IBzrLocalBranch)branch).getParent();
        }
        LocationInputDialog dialog = LocationInputDialog.remotePullLocationDialog(this.getShell(), locations, initialBranch, dialogInfo);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            return dialogInfo;
        }
        return null;
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }
}

