/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.LocationInputDialog;
import org.vcs.bazaar.eclipse.ui.operations.PushOperation;

public class PushAction
extends WorkbenchAction {
    protected void execute(IAction action) throws BazaarException, InvocationTargetException, InterruptedException {
        IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        this.execute((IBzrBranch)BzrWorkspaceRoot.getBranchFor((IProject)projects[0]));
    }

    protected void execute(IBzrBranch branch) throws InvocationTargetException, InterruptedException, BazaarException {
        LocationInputDialog.LocationDialogInfo dialogInfo = this.getRemoteLocation(branch);
        if (dialogInfo != null && dialogInfo.getLocation() != null && !dialogInfo.getLocation().trim().isEmpty()) {
            try {
                BranchLocation remoteLocation = new BranchLocation(dialogInfo.getLocation());
                new PushOperation(this.getTargetPart(), branch, remoteLocation, dialogInfo.isRemember(), dialogInfo.isOverwrite(), dialogInfo.isUseExistingDir()).run();
            }
            catch (BazaarClientException e) {
                EclipseBazaarUI.log(e.getMessage(), e);
                throw new InvocationTargetException(e, e.getMessage());
            }
        }
    }

    private LocationInputDialog.LocationDialogInfo getRemoteLocation(IBzrBranch branch) {
        LocationInputDialog.LocationDialogInfo dialogInfo = new LocationInputDialog.LocationDialogInfo();
        try {
            Collection<IBzrBranch> locations = this.getAllBranchLocations(branch);
            IBzrBranch initialBranch = null;
            if (branch instanceof IBzrLocalBranch) {
                initialBranch = ((IBzrLocalBranch)branch).getPushBranch();
            }
            LocationInputDialog dialog = LocationInputDialog.remotePushLocationDialog(this.getShell(), locations, initialBranch, dialogInfo);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                return dialogInfo;
            }
        }
        catch (Exception ex) {
            this.handle(ex);
        }
        return null;
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }
}

