/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.commands.ConflictsCommand;
import org.vcs.bazaar.eclipse.core.commands.RebaseAbortCommand;
import org.vcs.bazaar.eclipse.core.commands.RebaseCommand;
import org.vcs.bazaar.eclipse.core.commands.RebaseContinueCommand;
import org.vcs.bazaar.eclipse.core.commands.RebaseToDoCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.RebaseDialog;

public class RebaseAction
extends WorkbenchAction {
    protected void execute(IAction action) throws BazaarException, InvocationTargetException, InterruptedException {
        IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor((IProject)projects[0]);
        RebaseToDoCommand cmd = new RebaseToDoCommand((IBzrBranch)branch);
        cmd.run((IProgressMonitor)new NullProgressMonitor());
        if (cmd.isRebaseInterrupted()) {
            this.resumeRebase((IBzrBranch)branch);
        } else {
            this.startRebase((IBzrBranch)branch);
        }
    }

    private void resumeRebase(IBzrBranch branch) throws BazaarException, InvocationTargetException, InterruptedException {
        ConflictsCommand cmd = new ConflictsCommand(branch);
        cmd.run((IProgressMonitor)new NullProgressMonitor());
        if (!cmd.getConflicts().isEmpty()) {
            MessageDialog dialog = new MessageDialog(this.getParentShell(), UITexts.BazaarRebaseDialogTitle, null, UITexts.RebaseConflictsDialog_label, 3, new String[]{UITexts.RebaseResumeDialog_abort, IDialogConstants.CLOSE_LABEL}, 1);
            dialog.setBlockOnOpen(true);
            int result = dialog.open();
            if (result == 0) {
                this.abortRebase(branch);
            }
        } else {
            MessageDialog dialog = new MessageDialog(this.getParentShell(), UITexts.BazaarRebaseDialogTitle, null, UITexts.RebaseResumeDialog_label, 6, new String[]{UITexts.RebaseResumeDialog_continue, IDialogConstants.CLOSE_LABEL, UITexts.RebaseResumeDialog_abort}, 0);
            int result = dialog.open();
            if (result == 2) {
                this.abortRebase(branch);
            } else if (result == 0) {
                this.continueRebase(branch);
            }
        }
    }

    private void abortRebase(IBzrBranch branch) throws InvocationTargetException, InterruptedException {
        this.runRebaseCommand((BazaarCommand)new RebaseAbortCommand(branch));
    }

    private void continueRebase(IBzrBranch branch) throws InvocationTargetException, InterruptedException {
        this.runRebaseCommand((BazaarCommand)new RebaseContinueCommand(branch));
    }

    public void startRebase(IBzrBranch branch) throws BazaarException, InvocationTargetException, InterruptedException {
        RebaseDialog.RebaseDialogInfo dialogInfo = new RebaseDialog.RebaseDialogInfo();
        BranchLocation remoteLocation = this.getRemoteLocation(branch, dialogInfo);
        RebaseCommand cmd = new RebaseCommand(branch, remoteLocation, dialogInfo.getOptions().toArray(new Option[0]));
        if (remoteLocation != null) {
            this.runRebaseCommand((BazaarCommand)cmd);
        }
    }

    private BranchLocation getRemoteLocation(IBzrBranch branch, RebaseDialog.RebaseDialogInfo dialogInfo) throws BazaarException {
        Collection<IBzrBranch> locations = this.getAllBranchLocations(branch);
        IBzrBranch initialBranch = null;
        if (branch instanceof IBzrLocalBranch) {
            initialBranch = ((IBzrLocalBranch)branch).getParent();
        }
        RebaseDialog dialog = new RebaseDialog(this.getShell(), locations, initialBranch, dialogInfo);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            try {
                return new BranchLocation(dialogInfo.getLocation());
            }
            catch (BazaarClientException bazaarClientException) {}
        }
        return null;
    }

    private void runRebaseCommand(final BazaarCommand cmd) throws InvocationTargetException, InterruptedException {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask("", 1000);
                        monitor.setTaskName(CoreTexts.RebaseCommand_taskName);
                        cmd.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                    }
                    catch (BazaarException e) {
                        EclipseBazaarUI.log(e.getMessage(), (CoreException)((Object)e));
                        throw new InvocationTargetException(e, e.getMessage());
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, false, 1);
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }

    protected boolean isEnabledByType(IResource resource) {
        return resource.getType() == 4 && EclipseBazaarCore.getDefault().getPlugin("rewrite") != null;
    }
}

