/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IRevertOptions;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.commands.RevertCommand;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.ShowLogDialog;

public class ReplaceWithRevisionAction
extends WorkbenchAction {
    protected void execute(IAction action) throws Exception {
        IResource[] resources = this.getSelectedResources();
        ShowLogDialog dialog = new ShowLogDialog(this.getShell(), resources[0]);
        if (dialog.open() == 0 && dialog.getSelectedRevision() != null) {
            BazaarRevision revision = dialog.getSelectedRevision();
            this.revertChanges(new Option[]{IRevertOptions.NO_BACKUP, IRevertOptions.REVISION.with(revision.toString())});
        }
    }

    protected void revertChanges(Option[] options) throws InvocationTargetException, InterruptedException {
        IBzrLocalResource[] resources = BzrWorkspaceRoot.getBzrResourcesFor((IResource[])this.getSelectedResources());
        final RevertCommand cmd = new RevertCommand(Arrays.asList(resources), false, options);
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        cmd.run(monitor);
                    }
                    catch (BazaarException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, false, 1);
    }

    protected boolean isEnabledForMultipleResources() {
        return true;
    }

    protected boolean isEnabledByType(IResource resource) {
        return resource.getType() == 1 || resource.getType() == 2 || resource.getType() == 4;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForUnmodifiedResources() {
        return true;
    }
}

