/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.ResolveCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;

public class ResolveAction
extends WorkbenchAction {
    protected Option[] getOptions() {
        return new Option[0];
    }

    public static void runResolve(IProgressMonitor monitor, IResource[] selectedResources, Option ... options) throws InvocationTargetException {
        try {
            try {
                Map<IBzrBranch, List<IResource>> map = ResolveAction.getFilesByBranchMap(selectedResources);
                Set<IBzrBranch> keySet = map.keySet();
                monitor.beginTask("Resolving conflicts", keySet.size() * 1000);
                for (IBzrBranch branch : keySet) {
                    List<IResource> resources = map.get(branch);
                    ResolveCommand cmd = new ResolveCommand(resources, options);
                    cmd.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                }
            }
            catch (BazaarException e) {
                EclipseBazaarUI.log((CoreException)((Object)e));
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void execute(IAction action) throws BazaarException, InvocationTargetException, InterruptedException {
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                ResolveAction.runResolve(monitor, ResolveAction.this.getSelectedResources(), ResolveAction.this.getOptions());
            }
        }, false, 1);
    }

    protected boolean isEnabledForManagedResources() {
        return true;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }

    protected boolean isEnabledForMultipleResources() {
        return true;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForConflictedResources() {
        return true;
    }

    protected boolean isEnabledForUnmodifiedResources() {
        return false;
    }

    protected boolean isEnabledForModifiedResources() {
        return false;
    }
}

