/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.commands.RevertCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.actions.CommitAction;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.RevertDialog;

public class RevertAction
extends WorkbenchAction {
    protected void execute(IAction action) throws BazaarException, InvocationTargetException, InterruptedException {
        IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        List<IBzrResourceStatus> selectedResources = CommitAction.getCommitableResources((IProgressMonitor)new NullProgressMonitor(), this.getSelectedResources());
        List<IBzrResourceStatus> commiteableResources = CommitAction.getCommitableResources((IProgressMonitor)new NullProgressMonitor(), (IResource[])projects);
        RevertDialog dialog = new RevertDialog(this.getShell(), commiteableResources, selectedResources);
        dialog.setWholeBranchEnabled(true);
        if (dialog.open() != 0 || dialog.getSelection().size() == 0 && !dialog.isWholeBranch()) {
            return;
        }
        ArrayList<IBzrLocalResource> resourcesToRevert = new ArrayList<IBzrLocalResource>();
        if (dialog.isWholeBranch()) {
            resourcesToRevert.addAll(Arrays.asList(BzrWorkspaceRoot.getBzrResourcesFor((IResource[])projects)));
        } else {
            for (IBzrResourceStatus bzrResourceStatus : dialog.getSelection()) {
                resourcesToRevert.add(bzrResourceStatus.getResource());
            }
        }
        final RevertCommand cmd = new RevertCommand(resourcesToRevert, dialog.isWholeBranch(), dialog.getOptions());
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        cmd.run(monitor);
                    }
                    catch (BazaarException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, false, 1);
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    protected boolean isEnabledForUnmodifiedResources() {
        return this.getSelectedProjects().length > 0;
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }
}

