/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.UIJob;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IShelveOptions;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.ShelveCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.utils.BzrJobStatus;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.CommitAction;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.ShelveDialog;
import org.vcs.bazaar.eclipse.ui.operations.AddOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShelveAction
extends WorkbenchAction {
    @Override
    protected void execute(IAction action) throws Exception {
        final IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        final ShelveDialog shelveDialog = new ShelveDialog(this.getShell());
        UIJob job = new UIJob(this.getShell().getDisplay(), UITexts.ShelveAction_scanningTaskName){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask(UITexts.ShelveAction_scanningTaskName, 1000);
                try {
                    CommitAction.CommitableResources resourceStatuses = CommitAction.createCommitableResources(monitor, (IResource[])ShelveAction.this.getEnclosingProjectsForSelectedResources());
                    CommitAction.CommitableResources selectedResource = CommitAction.createCommitableResources(monitor, ShelveAction.this.getSelectedResources());
                    monitor.worked(1000);
                    ArrayList<IBzrResourceStatus> protectedProjects = new ArrayList<IBzrResourceStatus>();
                    for (IBzrResourceStatus status : resourceStatuses.getAllStatuses()) {
                        if (!status.isAdded() && !status.isUnknown() || !status.getResource().getName().equals(".project")) continue;
                        protectedProjects.add(status);
                    }
                    if (resourceStatuses.getAllStatuses().size() - protectedProjects.size() == 0) {
                        IStatus iStatus = BzrJobStatus.INFO((Job)this, (String)UITexts.ShelveAction_nothingToShelve);
                        return iStatus;
                    }
                    ArrayList<List<IBzrResourceStatus>> results = new ArrayList<List<IBzrResourceStatus>>(2);
                    List<IBzrResourceStatus> resources = resourceStatuses.getAllStatuses();
                    resources.removeAll(protectedProjects);
                    results.add(resources);
                    resources = selectedResource.getAllStatuses();
                    resources.removeAll(protectedProjects);
                    results.add(resources);
                    shelveDialog.setWholeBranchEnabled(protectedProjects.isEmpty());
                    BzrJobStatus bzrJobStatus = new BzrJobStatus(0, (Job)this, results, "Resources calculated");
                    return bzrJobStatus;
                }
                catch (Exception e) {
                    IStatus iStatus = UIJob.errorStatus((Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                if (status instanceof BzrJobStatus) {
                    List result;
                    int exit;
                    if (status.getSeverity() == 1) {
                        MessageDialog.openInformation((Shell)ShelveAction.this.getParentShell(), (String)UITexts.Dialog_informationTitle, (String)status.getMessage());
                    } else if (status.getSeverity() == 0 && (exit = shelveDialog.open((List)(result = (List)((BzrJobStatus)status).getResult()).get(0), (List)result.get(1), true)) == 0) {
                        try {
                            ShelveAction.this.handleSelected((List)result.get(0), projects, shelveDialog);
                        }
                        catch (Exception e) {
                            ShelveAction.this.handle(e);
                        }
                    }
                }
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
            }
        });
        job.schedule();
    }

    private void handleSelected(List<IBzrResourceStatus> commitableResources, IProject[] projects, ShelveDialog shelveDialog) throws BazaarException, InvocationTargetException, InterruptedException {
        String message = shelveDialog.getMessage();
        final boolean wholeBranch = shelveDialog.isWholeBranch();
        final ArrayList<Object> filesToAdd = new ArrayList<Object>();
        final ArrayList<IBzrLocalResource> resourcesToShelve = new ArrayList<IBzrLocalResource>();
        if (wholeBranch) {
            resourcesToShelve.addAll(Arrays.asList(BzrWorkspaceRoot.getBzrResourcesFor((IResource[])projects)));
            filesToAdd.addAll(Arrays.asList(projects));
        } else {
            resourcesToShelve.addAll(ShelveAction.getResources(shelveDialog.getSelectedFiles()));
            filesToAdd.addAll(ShelveAction.getUnknownResources(shelveDialog.getSelectedFiles()));
        }
        final ArrayList<Object> options = new ArrayList<Object>();
        options.add(IShelveOptions.ALL);
        if (message != null && !message.trim().isEmpty()) {
            options.add(IShelveOptions.MESSAGE.with(message));
        }
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, BazaarException {
                try {
                    monitor.beginTask(CoreTexts.ShelveCommand_taskName, filesToAdd.isEmpty() ? 1000 : 2000);
                    monitor.setTaskName(CoreTexts.ShelveCommand_taskName);
                    if (!filesToAdd.isEmpty()) {
                        new AddOperation(filesToAdd.toArray(new IResource[0]), true).run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                    }
                    ShelveCommand cmd = new ShelveCommand(resourcesToShelve, wholeBranch, options.toArray(new Option[0]));
                    cmd.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                }
                finally {
                    monitor.done();
                }
            }
        }, false, 1);
    }

    @Override
    protected boolean isEnabledForUnmodifiedResources() {
        return this.getSelectedProjects().length > 0;
    }

    @Override
    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }

    @Override
    protected boolean needsToSaveDirtyEditors() {
        return true;
    }
}

