/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.commands.SwitchCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.LocationInputDialog;

public class SwitchAction
extends WorkbenchAction {
    protected void execute(IAction action) throws BazaarException, InvocationTargetException, InterruptedException {
        LocationInputDialog.LocationDialogInfo dialogInfo;
        IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor((IProject)projects[0]);
        BranchLocation remoteLocation = this.getRemoteLocation((IBzrBranch)branch, dialogInfo = new LocationInputDialog.LocationDialogInfo());
        if (remoteLocation != null) {
            this.run(new IRunnableWithProgress((IBzrBranch)branch, remoteLocation, dialogInfo){
                private final /* synthetic */ IBzrBranch val$branch;
                private final /* synthetic */ BranchLocation val$remoteLocation;
                private final /* synthetic */ LocationInputDialog.LocationDialogInfo val$dialogInfo;
                {
                    this.val$branch = iBzrBranch;
                    this.val$remoteLocation = branchLocation;
                    this.val$dialogInfo = locationDialogInfo;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SwitchCommand cmd = new SwitchCommand(this.val$branch, this.val$remoteLocation);
                        cmd.setForce(this.val$dialogInfo.isForce());
                        cmd.setCreateBranch(this.val$dialogInfo.isCreateBranch());
                        cmd.run(monitor);
                    }
                    catch (BazaarException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, "Cannot switch a branch, only a checkout.", 1);
        }
    }

    private BranchLocation getRemoteLocation(IBzrBranch branch, LocationInputDialog.LocationDialogInfo dialogInfo) throws BazaarException {
        Collection<IBzrBranch> locations = this.getAllBranchLocations(branch);
        LocationInputDialog dialog = LocationInputDialog.switchLocationDialog(this.getShell(), locations, dialogInfo);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            try {
                return new BranchLocation(dialogInfo.getLocation());
            }
            catch (BazaarClientException bazaarClientException) {}
        }
        return null;
    }

    protected boolean isEnabledByType(IResource resource) {
        if (resource.getType() == 4) {
            BzrWorkspaceRoot root = BzrWorkspaceRoot.getBzrWorkspaceRootFor((IProject)((IProject)resource));
            return root.getBranch().isBound();
        }
        return false;
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }
}

