/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.IWorkbenchPart;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarResourceVariantTreeSubscriber;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSubscriberMergeContext;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSubscriberResourceMappingContext;
import org.vcs.bazaar.eclipse.core.synchronize.BazaarSynchronizeData;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.LocationInputDialog;
import org.vcs.bazaar.eclipse.ui.synchronize.BazaarModelSynchronizeParticipant;

public class SynchronizeAction
extends WorkbenchAction {
    private static ResourceMapping[] getResourceMappings(IResource[] elements) {
        ArrayList<ResourceMapping> mappings = new ArrayList<ResourceMapping>();
        IResource[] iResourceArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            ResourceMapping mapping = org.eclipse.ui.ide.ResourceUtil.getResourceMapping((Object)element);
            if (mapping != null && ResourceUtil.shouldHandle((IResource)element)) {
                mappings.add(mapping);
            }
            ++n2;
        }
        return mappings.toArray(new ResourceMapping[mappings.size()]);
    }

    protected void execute(IAction action) throws Exception {
        IResource[] resources = this.getSelectedResources();
        IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor((IProject)projects[0]);
        LocationInputDialog.LocationDialogInfo dialogInfo = this.getRemoteLocation((IBzrBranch)branch);
        if (dialogInfo != null && dialogInfo.getLocation() != null && !dialogInfo.getLocation().trim().isEmpty()) {
            BranchLocation remoteLocation = new BranchLocation(dialogInfo.getLocation());
            BazaarSynchronizeData syncData = new BazaarSynchronizeData(resources, remoteLocation);
            BazaarResourceVariantTreeSubscriber subscriber = new BazaarResourceVariantTreeSubscriber(syncData);
            BazaarSubscriberResourceMappingContext remoteContext = new BazaarSubscriberResourceMappingContext((Subscriber)subscriber);
            ResourceMapping[] mappings = SynchronizeAction.getResourceMappings(resources);
            SubscriberScopeManager manager = new SubscriberScopeManager(subscriber.getName(), mappings, (Subscriber)subscriber, (RemoteResourceMappingContext)remoteContext, true);
            BazaarSubscriberMergeContext context = new BazaarSubscriberMergeContext((Subscriber)subscriber, (ISynchronizationScopeManager)manager, syncData);
            BazaarModelSynchronizeParticipant participant = new BazaarModelSynchronizeParticipant(context);
            TeamUI.getSynchronizeManager().addSynchronizeParticipants(new ISynchronizeParticipant[]{participant});
            IWorkbenchPart activePart = null;
            if (this.window != null) {
                activePart = this.window.getActivePage().getActivePart();
            }
            participant.run(activePart);
        }
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }

    private LocationInputDialog.LocationDialogInfo getRemoteLocation(IBzrBranch branch) throws BazaarException {
        LocationInputDialog.LocationDialogInfo dialogInfo = new LocationInputDialog.LocationDialogInfo();
        Collection<IBzrBranch> locations = this.getAllBranchLocations(branch);
        IBzrBranch initialBranch = null;
        if (branch instanceof IBzrLocalBranch) {
            initialBranch = ((IBzrLocalBranch)branch).getParent();
        }
        LocationInputDialog dialog = LocationInputDialog.remoteLocationDialog(this.getShell(), locations, initialBranch, dialogInfo, "Please enter the URI to synchronize with");
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            return dialogInfo;
        }
        return null;
    }
}

