/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.UIJob;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IUnShelveOptions;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.ShelveListCommand;
import org.vcs.bazaar.eclipse.core.commands.UnShelveCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.utils.BzrJobStatus;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.WorkbenchAction;
import org.vcs.bazaar.eclipse.ui.dialogs.UnShelveDialog;

public class UnShelveAction
extends WorkbenchAction {
    protected void execute(IAction action) throws Exception {
        IProject[] projects = this.getEnclosingProjectsForSelectedResources();
        final UnShelveDialog unshelveDialog = new UnShelveDialog(this.getShell());
        IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor((IProject)projects[0]);
        UIJob job = new UIJob(this.getShell().getDisplay(), UITexts.UnShelveAction_gettingShelvesTaskName, (IBzrBranch)branch){
            private final /* synthetic */ IBzrBranch val$branch;
            {
                this.val$branch = iBzrBranch;
                super($anonymous0, $anonymous1);
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                monitor.beginTask(UITexts.UnShelveAction_gettingShelvesTaskName, 1000);
                try {
                    ShelveListCommand cmd = new ShelveListCommand(this.val$branch);
                    cmd.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                    if (cmd.getShelves().isEmpty()) {
                        IStatus iStatus = BzrJobStatus.INFO((Job)this, (String)UITexts.UnShelveAction_nothingToUnshelve);
                        return iStatus;
                    }
                    BzrJobStatus bzrJobStatus = new BzrJobStatus(0, (Job)this, (Object)cmd.getShelves(), "Resources calculated");
                    return bzrJobStatus;
                }
                catch (Exception e) {
                    IStatus iStatus = UIJob.errorStatus((Throwable)e);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.setUser(true);
        job.setPriority(30);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter((IBzrBranch)branch){
            private final /* synthetic */ IBzrBranch val$branch;
            {
                this.val$branch = iBzrBranch;
            }

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                if (status instanceof BzrJobStatus) {
                    int exit;
                    if (status.getSeverity() == 1) {
                        MessageDialog.openInformation((Shell)UnShelveAction.this.getParentShell(), (String)UITexts.Dialog_informationTitle, (String)status.getMessage());
                    } else if (status.getSeverity() == 0 && (exit = unshelveDialog.open((List)((BzrJobStatus)status).getResult())) == 0) {
                        try {
                            UnShelveAction.this.unshelve(this.val$branch, unshelveDialog);
                        }
                        catch (Exception e) {
                            UnShelveAction.this.handle(e);
                        }
                    }
                }
                event.getJob().removeJobChangeListener((IJobChangeListener)this);
            }
        });
        job.schedule();
    }

    private void unshelve(final IBzrBranch branch, UnShelveDialog unshelveDialog) throws InvocationTargetException, InterruptedException {
        final String shelfId = unshelveDialog.getShelfId();
        final ArrayList<Option> options = new ArrayList<Option>();
        if (unshelveDialog.isDryRun()) {
            options.add(IUnShelveOptions.DRY_RUN);
        }
        if (unshelveDialog.isKeep()) {
            options.add(IUnShelveOptions.KEEP);
        }
        if (unshelveDialog.isDeleteOnly()) {
            options.add(IUnShelveOptions.DELETE_ONLY);
        }
        this.run((IRunnableWithProgress)new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(CoreTexts.UnShelveCommand_taskName, 1000);
                        UnShelveCommand cmd = new UnShelveCommand(branch, shelfId, options.toArray(new Option[0]));
                        cmd.run(EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor));
                    }
                    catch (Exception e) {
                        EclipseBazaarUI.log(e.getMessage(), e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }, false, 1);
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return this.isSameBranchInEnclosingProjects();
    }
}

