/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.internal.core.model.LocalBranch;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.actions.WorkspaceAction;
import org.vcs.bazaar.eclipse.ui.branch.BranchLocationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WorkbenchAction
extends WorkspaceAction
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow window;

    @Override
    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    protected Shell getParentShell() {
        Shell shell;
        if (this.window != null && this.window.getShell() != null) {
            shell = this.window.getShell();
        } else {
            IWorkbench workbench = PlatformUI.getWorkbench();
            shell = workbench.getActiveWorkbenchWindow().getShell();
        }
        return shell;
    }

    protected IWorkbenchPage getActivePage() {
        if (this.window != null) {
            return this.window.getActivePage();
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        return win.getActivePage();
    }

    protected Collection<IBzrBranch> getAllSavedBranches() throws BazaarException {
        TreeSet<IBzrBranch> locations = new TreeSet<IBzrBranch>();
        for (IBzrBranch branch : BranchLocationManager.getAllBranches()) {
            if (branch == null || branch.getBranchLocation() == null) continue;
            locations.add(branch);
        }
        return locations;
    }

    private void addBranchIfValid(Collection<IBzrBranch> branches, String location) {
        IBzrBranch branch = BranchFactory.findOrCreateFor((String)location);
        if (branch != null) {
            branches.add(branch);
        }
    }

    protected Collection<IBzrBranch> getAllBranchLocations(IBzrBranch branch) throws BazaarException {
        IBazaarInfo info;
        IBazaarInfo.RelatedBranches rb;
        Collection<IBzrBranch> locations = this.getAllSavedBranches();
        if (branch instanceof LocalBranch && (rb = (info = ((LocalBranch)branch).getInfo()).getRelatedBranches()) != null) {
            this.addBranchIfValid(locations, rb.getParentBranch());
            this.addBranchIfValid(locations, rb.getPushBranch());
            this.addBranchIfValid(locations, rb.getPublicBranch());
            this.addBranchIfValid(locations, rb.getSubmitBranch());
        }
        return locations;
    }

    public static List<IResource> getUnknownOrAddedResources(List<IBzrResourceStatus> selection) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (IBzrResourceStatus status : selection) {
            if (!status.isAdded() && !status.isUnknown()) continue;
            result.add(status.getResource().getIResource());
        }
        return result;
    }

    public static List<IResource> getUnknownResources(List<IBzrResourceStatus> selection) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (IBzrResourceStatus status : selection) {
            if (!status.isUnknown()) continue;
            result.add(status.getResource().getIResource());
        }
        return result;
    }

    public static List<IBzrLocalResource> getResources(List<IBzrResourceStatus> selection) {
        ArrayList<IBzrLocalResource> result = new ArrayList<IBzrLocalResource>();
        for (IBzrResourceStatus status : selection) {
            result.add(status.getResource());
        }
        return result;
    }

    protected String handleConflicts(InvocationTargetException ite) throws InvocationTargetException {
        String message = null;
        Throwable ie = ite.getCause();
        if (ie instanceof BazaarException) {
            if (ie.getCause() != null) {
                ie = ie.getCause();
            }
            if (ie.getMessage().contains("conflicts encountered")) {
                message = String.valueOf(UITexts.Conflicts_error) + ie.getMessage();
                ite = null;
            }
        }
        if (ite != null) {
            throw ite;
        }
        return message;
    }
}

