/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.core.TeamException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.BzrStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.ui.actions.BzrAction;

public abstract class WorkspaceAction
extends BzrAction {
    protected boolean isEnabled() throws TeamException {
        IResource[] resources = this.getSelectedResources();
        if (!EclipseBazaarCore.getDefault().isClientAvailable()) {
            return false;
        }
        if (resources.length == 0) {
            return false;
        }
        if (!this.isEnabledForMultipleResources() && resources.length != 1) {
            return false;
        }
        if (resources.length != 1 && this.getSelectedProjects().length != resources.length && this.isEnabledForMultipleProjectsOnly()) {
            return false;
        }
        if (!this.isEnabledForMultipleEclosingProjects() && this.getEnclosingProjectsForSelectedResources().length != 1) {
            return false;
        }
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!ResourceUtil.shouldHandle((IResource)resource)) {
                return false;
            }
            if (!this.isEnabledByType(resource)) {
                return false;
            }
            IBzrLocalResource bzrResource = BzrWorkspaceRoot.getBzrResourceFor((IResource)resource);
            if (!this.isEnabledForBzrResource(bzrResource)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isEnabledByType(IResource resource) {
        return true;
    }

    protected boolean isEnabledForMultipleResources() {
        return true;
    }

    protected boolean isEnabledForMultipleEclosingProjects() {
        return false;
    }

    protected boolean isEnabledForMultipleProjectsOnly() {
        return false;
    }

    protected boolean isEnabledForManagedResources() {
        return true;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    protected boolean isEnabledForAddedResources() {
        return true;
    }

    protected boolean isEnabledForRenamedResources() {
        return true;
    }

    protected boolean isEnabledForModifiedResources() {
        return true;
    }

    protected boolean isEnabledForUnmodifiedResources() {
        return true;
    }

    protected boolean isEnabledForConflictedResources() {
        return false;
    }

    private boolean isEnabledForBzrResource(IBzrLocalResource bzrResource) {
        boolean managed = false;
        boolean added = false;
        boolean renamed = false;
        boolean modified = false;
        boolean conflicts = false;
        BzrStatus status = null;
        try {
            status = bzrResource.getStatus();
        }
        catch (CoreException coreException) {
            return false;
        }
        if (status != null && !status.isIgnored()) {
            renamed = status.isRenamed();
            added = status.isAdded();
            managed = !status.isUnknown();
            modified = status.isHasConflicts() || status.isKindChange() || status.isModified() || status.isRenamed() || status.isUnknown() || status.isXBitChanged() || status.isAdded() || status.isDeleted();
            conflicts = status.isHasConflicts();
        }
        if (conflicts && this.isEnabledForConflictedResources()) {
            return true;
        }
        if (managed && !this.isEnabledForManagedResources()) {
            return false;
        }
        if (!managed && !this.isEnabledForUnmanagedResources()) {
            return false;
        }
        if (renamed && !this.isEnabledForRenamedResources()) {
            return false;
        }
        if (added && !this.isEnabledForAddedResources()) {
            return false;
        }
        if (modified && !this.isEnabledForModifiedResources()) {
            return false;
        }
        return modified || this.isEnabledForUnmodifiedResources();
    }
}

