/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.annotaions;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.AnnotateCommand;
import org.vcs.bazaar.eclipse.core.history.BazaarFileHistory;
import org.vcs.bazaar.eclipse.core.history.BazaarFileRevision;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalFile;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.annotaions.AnnotateBlock;
import org.vcs.bazaar.eclipse.ui.annotaions.AnnotateBlocks;
import org.vcs.bazaar.eclipse.ui.annotaions.AnnotateInformationControl;
import org.vcs.bazaar.eclipse.ui.annotaions.CommitterColors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowAnnotationOperation
extends TeamOperation {
    private static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private final IBzrLocalFile remoteFile;

    public ShowAnnotationOperation(IWorkbenchPart part, IBzrLocalFile remoteFile) {
        super(part);
        this.remoteFile = remoteFile;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(null, 100);
        try {
            try {
                AnnotateCommand cmd = new AnnotateCommand((IBzrLocalResource)this.remoteFile);
                cmd.run((IProgressMonitor)new NullProgressMonitor());
                AnnotateBlocks annotateBlocks = new AnnotateBlocks(cmd.getAnnotation());
                final RevisionInformation information = this.createRevisionInformation(annotateBlocks, monitor);
                new UIJob("Bazaar Annotate"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        monitor.beginTask("Applying Annotation", -1);
                        AbstractDecoratedTextEditor editor = ShowAnnotationOperation.this.getEditor();
                        if (editor != null) {
                            editor.showRevisionInformation(information, "org.vcs.bazaar.eclipse.quickdiff.providers.BazaarReferenceProvider");
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            catch (CoreException e) {
                EclipseBazaarUI.log(e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected IAction getGotoAction() {
        return super.getGotoAction();
    }

    private AbstractDecoratedTextEditor getEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IEditorReference[] references = window.getActivePage().getEditorReferences();
        IResource resource = this.remoteFile.getIResource();
        if (resource == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = references;
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            try {
                if (resource != null && resource.equals(reference.getEditorInput().getAdapter(IFile.class))) {
                    IEditorPart editor = reference.getEditor(false);
                    if (editor instanceof AbstractDecoratedTextEditor) {
                        return (AbstractDecoratedTextEditor)editor;
                    }
                    IEditorPart part = this.getPart().getSite().getPage().openEditor((IEditorInput)new FileEditorInput((IFile)resource), DEFAULT_TEXT_EDITOR_ID, true, 0);
                    if (part != null && part instanceof AbstractDecoratedTextEditor) {
                        return (AbstractDecoratedTextEditor)part;
                    }
                }
            }
            catch (PartInitException partInitException) {}
            ++n2;
        }
        if (resource instanceof IFile) {
            try {
                IEditorPart part;
                IEditorDescriptor descrptr = IDE.getEditorDescriptor((IFile)((IFile)resource));
                if (descrptr.isInternal()) {
                    IEditorPart part2 = IDE.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)((IFile)resource));
                    if (part2 instanceof AbstractDecoratedTextEditor) {
                        return (AbstractDecoratedTextEditor)part2;
                    }
                    this.getPart().getSite().getPage().closeEditor(part2, false);
                }
                if ((part = IDE.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)((IFile)resource), (String)DEFAULT_TEXT_EDITOR_ID)) != null && part instanceof AbstractDecoratedTextEditor) {
                    return (AbstractDecoratedTextEditor)part;
                }
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }

    private RevisionInformation createRevisionInformation(AnnotateBlocks annotateBlocks, IProgressMonitor monitor) throws BazaarException {
        HashMap<String, BazaarFileRevision> logEntriesByRevision = new HashMap<String, BazaarFileRevision>();
        BazaarFileHistory fileHistory = new BazaarFileHistory(this.remoteFile.getIResource());
        IProgressMonitor subMonitor = EclipseBazaarCore.subProgressMonitorFor((IProgressMonitor)monitor);
        try {
            try {
                fileHistory.refresh(subMonitor, false);
                logEntriesByRevision.putAll(this.getLogEntriesByRevision(fileHistory.getFileRevisions()));
            }
            catch (CoreException e) {
                throw BazaarException.wrapException((CoreException)e);
            }
        }
        finally {
            subMonitor.done();
        }
        RevisionInformation info = new RevisionInformation();
        final class AnnotationControlCreator
        implements IInformationControlCreator {
            private final String statusFieldText;

            public AnnotationControlCreator(String statusFieldText) {
                this.statusFieldText = statusFieldText;
            }

            public IInformationControl createInformationControl(Shell parent) {
                return new AnnotateInformationControl(parent, this.statusFieldText);
            }
        }
        info.setHoverControlCreator((IInformationControlCreator)new AnnotationControlCreator("Press 'F2' for focus"));
        info.setInformationPresenterControlCreator((IInformationControlCreator)new AnnotationControlCreator(null));
        CommitterColors colors = CommitterColors.getDefault();
        HashMap<String, Revision> sets = new HashMap<String, Revision>();
        for (AnnotateBlock block : annotateBlocks.getAnnotateBlocks()) {
            BazaarFileRevision bzrRevision = (BazaarFileRevision)logEntriesByRevision.get(block.getRevision());
            if (bzrRevision == null) continue;
            IBazaarLogMessage logEntry = bzrRevision.getIBazaarLogMessage();
            Revision revision = (Revision)sets.get(block.getRevision());
            if (revision == null) {
                revision = new BazaarAnnotateRevision(colors, logEntry, block);
                sets.put(block.getRevision(), revision);
                info.addRevision(revision);
            }
            revision.addRange((ILineRange)new LineRange(block.getStartLine(), block.getEndLine() - block.getStartLine() + 1));
        }
        return info;
    }

    private Map<String, BazaarFileRevision> getLogEntriesByRevision(IFileRevision[] fileRevisions) {
        HashMap<String, BazaarFileRevision> logEntriesByRevision = new HashMap<String, BazaarFileRevision>(fileRevisions.length);
        IFileRevision[] iFileRevisionArray = fileRevisions;
        int n = fileRevisions.length;
        int n2 = 0;
        while (n2 < n) {
            IFileRevision fileRev = iFileRevisionArray[n2];
            BazaarFileRevision bzrFileRev = (BazaarFileRevision)fileRev;
            if (bzrFileRev.getChildren() != null && bzrFileRev.getChildren().length > 0) {
                logEntriesByRevision.putAll(this.getLogEntriesByRevision((IFileRevision[])bzrFileRev.getChildren()));
            }
            logEntriesByRevision.put(bzrFileRev.getRevision().getValue(), bzrFileRev);
            ++n2;
        }
        return logEntriesByRevision;
    }

    private final class BazaarAnnotateRevision
    extends Revision {
        private final CommitterColors colors;
        private final IBazaarLogMessage log;
        private final AnnotateBlock block;

        private BazaarAnnotateRevision(CommitterColors colors, IBazaarLogMessage log, AnnotateBlock block) {
            this.colors = colors;
            this.log = log;
            this.block = block;
        }

        public Object getHoverInfo() {
            String date = DateFormat.getDateTimeInstance(2, 3).format(this.getDate());
            return String.valueOf(this.block.getUser()) + " " + this.block.getRevision() + " " + date + "\n\n" + (this.log != null ? this.log.getMessage() : "");
        }

        public String getAuthor() {
            return this.block.getUser();
        }

        public String getId() {
            return this.block.getRevision();
        }

        public Date getDate() {
            return this.log.getDate();
        }

        public RGB getColor() {
            return this.colors.getCommitterRGB(this.getAuthor());
        }
    }
}

