/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.branch;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchLocationManager {
    private static final String KEY_LOCATION = "location";
    private static final String KEY_LOCATIONS = "locations";
    private static Set<IBzrBranch> branches;

    public static Set<IBzrBranch> getAllBranches() {
        if (branches == null) {
            branches = new TreeSet<IBzrBranch>();
            for (BranchLocation location : BranchLocationManager.getLocations()) {
                branches.add(BranchFactory.getBranch((BranchLocation)location));
            }
        }
        return branches;
    }

    private static Set<BranchLocation> getLocations() {
        XMLMemento memento;
        String all = BranchLocationManager.getPreferenceStore().getString("branch_location_history");
        if (all.length() == 0) {
            return Collections.emptySet();
        }
        int max = BranchLocationManager.getLocationHistorySize();
        if (max < 1) {
            return Collections.emptySet();
        }
        try {
            memento = XMLMemento.createReadRoot((Reader)new StringReader(all));
        }
        catch (WorkbenchException workbenchException) {
            return Collections.emptySet();
        }
        LinkedHashSet<BranchLocation> locations = new LinkedHashSet<BranchLocation>();
        IMemento[] iMementoArray = memento.getChildren(KEY_LOCATION);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            try {
                locations.add(new BranchLocation(child.getTextData()));
                if (locations.size() == max) {
                    break;
                }
            }
            catch (BazaarClientException bazaarClientException) {}
            ++n2;
        }
        return locations;
    }

    public static void saveBranchLocation(String location) {
        if (location == null || location.trim().isEmpty()) {
            return;
        }
        try {
            int size = BranchLocationManager.getLocationHistorySize();
            ArrayList<BranchLocation> locations = new ArrayList<BranchLocation>();
            if (size > 0) {
                BranchLocation bl = new BranchLocation(location);
                locations.add(bl);
                if (locations.size() < size) {
                    Set<BranchLocation> history = BranchLocationManager.getLocations();
                    history.remove(bl);
                    for (BranchLocation previous : history) {
                        locations.add(previous);
                        if (locations.size() == size) break;
                    }
                }
            }
            BranchLocationManager.saveBranchLocations(locations, "branch_location_history");
            branches = null;
        }
        catch (BazaarClientException bazaarClientException) {}
    }

    private static void saveBranchLocations(Collection<BranchLocation> locations, String preferenceKey) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)KEY_LOCATIONS);
        for (BranchLocation l : locations) {
            memento.createChild(KEY_LOCATION).putTextData(l.toString());
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            BranchLocationManager.getPreferenceStore().setValue(preferenceKey, writer.toString());
        }
        catch (IOException iOException) {}
    }

    private static IPreferenceStore getPreferenceStore() {
        return EclipseBazaarUI.getDefault().getPreferenceStore();
    }

    private static int getLocationHistorySize() {
        return 10;
    }
}

