/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.ui.compare.BazaarResourceNode;
import org.vcs.bazaar.eclipse.ui.compare.internal.Utilities;

public class BazaarLocalResourceNode
extends BazaarResourceNode {
    private boolean fDirty = false;
    private IFile fDeleteFile;
    private IContentChangeListener listener;

    public BazaarLocalResourceNode(IBzrLocalResource resource) {
        super(resource);
    }

    public BazaarLocalResourceNode(IResource resource) {
        super(resource);
    }

    public void addContentChangeListener(IContentChangeListener listener) {
        super.addContentChangeListener(listener);
        this.listener = listener;
    }

    public void setContent(byte[] contents) {
        this.fDirty = true;
        super.setContent(contents);
    }

    public ITypedElement replace(ITypedElement child, ITypedElement other) {
        IFile file;
        IContainer container;
        IResource resource;
        if (child == null && (resource = this.getResource()) instanceof IContainer) {
            container = (IContainer)resource;
            file = container.getFile((IPath)new Path(other.getName()));
            BazaarLocalResourceNode localNode = new BazaarLocalResourceNode((IResource)file);
            localNode.addContentChangeListener(this.listener);
            child = localNode;
        }
        if (other == null) {
            resource = this.getResource();
            if (resource instanceof IContainer && (file = (container = (IContainer)resource).getFile((IPath)new Path(child.getName()))) != null && file.exists()) {
                this.fDeleteFile = file;
                this.fDirty = true;
                this.fireContentChanged();
            }
            return null;
        }
        if (other instanceof IStreamContentAccessor && child instanceof IEditableContent) {
            IEditableContent dst = (IEditableContent)child;
            try {
                InputStream is = ((IStreamContentAccessor)other).getContents();
                byte[] bytes = Utilities.readBytes(is);
                if (bytes != null) {
                    dst.setContent(bytes);
                }
            }
            catch (CoreException coreException) {}
        }
        return child;
    }

    public void commit(IProgressMonitor monitor) throws CoreException {
        if (this.fDirty) {
            InputStream is;
            block16: {
                block17: {
                    is = null;
                    try {
                        if (this.fDeleteFile == null) break block16;
                        this.fDeleteFile.delete(true, true, monitor);
                        if (is == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                return;
            }
            byte[] content = this.getContent();
            if (content == null) {
                content = new byte[]{};
            }
            is = new ByteArrayInputStream(content);
            IResource resource = this.getResource();
            if (resource instanceof IFile) {
                IFile file = (IFile)this.getResource();
                if (file.exists()) {
                    file.setContents(is, false, true, monitor);
                } else {
                    file.create(is, false, monitor);
                }
            }
            this.fDirty = false;
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

