/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.compare;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.vcs.bazaar.eclipse.ui.compare.BazaarLocalResourceNode;

public class BazaarResourceDiffNodeTree {
    private boolean readonly;
    private IResource[] roots;
    private List<DiffNode> nodes;
    private IContentChangeListener listener;

    public BazaarResourceDiffNodeTree(boolean readonly, IResource[] roots, IContentChangeListener listener) {
        this.readonly = readonly;
        this.roots = roots;
        this.nodes = new ArrayList<DiffNode>();
        this.listener = listener;
    }

    public void add(ResourceNode left, ResourceNode right) {
        DiffNode diffNode = left != null && right != null ? new DiffNode(null, 3, null, (ITypedElement)left, (ITypedElement)right) : (left == null ? new DiffNode(1, null, null, (ITypedElement)right) : new DiffNode(2, null, (ITypedElement)left, null));
        this.nodes.add(diffNode);
    }

    private boolean isRoot(IResource resource) {
        IResource[] iResourceArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource root = iResourceArray[n2];
            if (root.equals((Object)resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IResource findBestRoot(ResourceNode node) {
        IResource resource = node.getResource();
        IResource root = null;
        while (resource != null) {
            if (this.isRoot(resource)) {
                root = resource;
            }
            resource = resource.getParent();
        }
        return root;
    }

    public DiffNode getNodes() {
        ResourceNode brn;
        DiffNode node2;
        LinkedHashMap<IResource, DiffNode> nodeMap = new LinkedHashMap<IResource, DiffNode>();
        for (DiffNode node2 : this.nodes) {
            brn = (ResourceNode)(node2.getLeft() != null ? node2.getLeft() : node2.getRight());
            nodeMap.put(brn.getResource(), node2);
        }
        block1: for (DiffNode node2 : this.nodes) {
            brn = (ResourceNode)(node2.getLeft() != null ? node2.getLeft() : node2.getRight());
            IResource root = this.findBestRoot(brn);
            IResource resource = brn.getResource();
            while (resource.getParent() != null && !resource.equals((Object)root)) {
                DiffNode parentNode = (DiffNode)nodeMap.get(resource = resource.getParent());
                if (parentNode != null) {
                    parentNode.add((IDiffElement)node2);
                    continue block1;
                }
                ResourceNode folderNodeLeft = this.readonly ? new ResourceNode(resource) : new BazaarLocalResourceNode(resource);
                folderNodeLeft.addContentChangeListener(this.listener);
                ResourceNode folderNodeRight = new ResourceNode(resource);
                parentNode = new DiffNode(null, 3, null, (ITypedElement)folderNodeLeft, (ITypedElement)folderNodeRight);
                nodeMap.put(resource, parentNode);
                parentNode.add((IDiffElement)node2);
                node2 = parentNode;
            }
        }
        if (nodeMap.size() == 1) {
            return (DiffNode)nodeMap.values().iterator().next();
        }
        if (this.roots.length == 1 && (node2 = (DiffNode)nodeMap.get(this.roots[0])) != null) {
            return node2;
        }
        DiffNode rootNode = new DiffNode(null, 3, null, (ITypedElement)new ResourceNode((IResource)this.roots[0].getParent()), (ITypedElement)new ResourceNode((IResource)this.roots[0].getParent()));
        IResource[] iResourceArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource root = iResourceArray[n2];
            DiffNode node3 = (DiffNode)nodeMap.get(root);
            if (node3 != null) {
                rootNode.add((IDiffElement)node3);
            }
            ++n2;
        }
        return rootNode;
    }
}

