/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.ui.compare.BazaarLocalResourceNode;
import org.vcs.bazaar.eclipse.ui.compare.BazaarResourceDiffNodeTree;
import org.vcs.bazaar.eclipse.ui.compare.BazaarResourceNode;
import org.vcs.bazaar.eclipse.ui.compare.BazaarRevisionNode;
import org.vcs.bazaar.eclipse.ui.compare.CompareEditorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BazaarStatusBasedCompareEditorInput
extends CompareEditorInput
implements IContentChangeListener {
    private IResource[] resources;
    private List<IBzrResourceStatus> statuses;
    private BazaarRevision leftRevision;
    private BazaarRevision rightRevision;
    private boolean readOnly;
    private List<BazaarLocalResourceNode> changedNodes;

    public BazaarStatusBasedCompareEditorInput(IResource[] resources, List<IBzrResourceStatus> statuses, BazaarRevision leftRevision, BazaarRevision rightRevision, IWorkbenchPage page) {
        super(new CompareConfiguration());
        this.resources = resources;
        this.statuses = statuses;
        this.leftRevision = leftRevision;
        this.rightRevision = rightRevision;
        this.readOnly = leftRevision != null;
        this.changedNodes = new ArrayList<BazaarLocalResourceNode>();
    }

    protected ICompareInput prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ICompareInput input = this.createCompareInput();
        this.getCompareConfiguration().setRightEditable(false);
        this.getCompareConfiguration().setLeftEditable(this.isLeftEditable(input));
        this.initLabels(input);
        return input;
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        this.flushViewers(monitor);
        ArrayList<BazaarLocalResourceNode> nodes = new ArrayList<BazaarLocalResourceNode>(this.changedNodes);
        this.changedNodes.clear();
        for (ResourceNode resourceNode : nodes) {
            if (!(resourceNode instanceof BazaarLocalResourceNode)) continue;
            ((BazaarLocalResourceNode)resourceNode).commit(monitor);
        }
    }

    private ICompareInput createCompareInput() {
        BazaarResourceDiffNodeTree tree = new BazaarResourceDiffNodeTree(this.readOnly, this.resources, this);
        for (IBzrResourceStatus local : this.statuses) {
            BazaarResourceNode ln = null;
            BazaarRevisionNode rn = null;
            IBzrLocalResource localResource = local.getResource();
            if (!local.isDeleted()) {
                ln = this.leftRevision == null ? new BazaarLocalResourceNode(localResource) : new BazaarRevisionNode(localResource, this.leftRevision);
                ln.addContentChangeListener(this);
            }
            if (!(local.isAdded() || local.isUnversioned() || local.isUnknown())) {
                BazaarRevisionNode bazaarRevisionNode = rn = this.rightRevision == null ? new BazaarRevisionNode(localResource) : new BazaarRevisionNode(localResource, this.rightRevision);
            }
            if (ln == null && rn == null) continue;
            tree.add(ln, rn);
        }
        return tree.getNodes();
    }

    private void initLabels(ICompareInput input) {
        CompareEditorUtil.setLabels(this, input.getLeft(), input.getRight(), this.leftRevision, this.rightRevision);
    }

    private boolean isLeftEditable(ICompareInput input) {
        ITypedElement left = input.getLeft();
        if (left instanceof IEditableContent) {
            return ((IEditableContent)left).isEditable();
        }
        return !this.readOnly;
    }

    public void contentChanged(IContentChangeNotifier source) {
        if (source instanceof BazaarLocalResourceNode) {
            this.changedNodes.add((BazaarLocalResourceNode)source);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BazaarStatusBasedCompareEditorInput) {
            boolean eq;
            BazaarStatusBasedCompareEditorInput other = (BazaarStatusBasedCompareEditorInput)((Object)obj);
            boolean bl = eq = this.resources.length == other.resources.length;
            if (eq) {
                boolean bl2 = this.leftRevision != null ? this.leftRevision.equals((Object)other.leftRevision) : (eq = other.leftRevision == null);
            }
            if (eq) {
                boolean bl3 = this.rightRevision != null ? this.rightRevision.equals((Object)other.rightRevision) : (eq = other.rightRevision == null);
            }
            if (eq) {
                IResource res;
                HashSet<IResource> rs = new HashSet<IResource>();
                IResource[] iResourceArray = this.resources;
                int n = this.resources.length;
                int n2 = 0;
                while (n2 < n) {
                    res = iResourceArray[n2];
                    rs.add(res);
                    ++n2;
                }
                iResourceArray = other.resources;
                n = other.resources.length;
                n2 = 0;
                while (n2 < n) {
                    res = iResourceArray[n2];
                    rs.remove(res);
                    ++n2;
                }
                eq = rs.isEmpty();
            }
            return eq;
        }
        return false;
    }
}

