/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.compare;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.history.IFileRevision;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.compare.BazaarRevisionNode;

public class CompareEditorUtil {
    static IFileRevision getRevision(ITypedElement left) {
        if (left instanceof IFileRevision) {
            return (IFileRevision)left;
        }
        return null;
    }

    static String formatRevision(BazaarRevision revision) {
        StringBuilder sb = new StringBuilder();
        sb.append(revision.toString());
        return sb.toString();
    }

    static String getRevisionName(ITypedElement element, BazaarRevision revision) {
        if (revision != null) {
            return CompareEditorUtil.formatRevision(revision);
        }
        if (CompareEditorUtil.getRevision(element) != null) {
            return CompareEditorUtil.getRevision(element).getName();
        }
        if (element instanceof BazaarRevisionNode) {
            return CompareEditorUtil.formatRevision(((BazaarRevisionNode)element).getRevision());
        }
        return null;
    }

    static IResource getResource(ITypedElement left) {
        if (left instanceof IResourceProvider) {
            IResourceProvider resourceProvider = (IResourceProvider)left;
            return resourceProvider.getResource();
        }
        return null;
    }

    static String getResourceName(ITypedElement left, ITypedElement right) {
        IResource resource = CompareEditorUtil.getResource(left);
        if (resource == null) {
            resource = CompareEditorUtil.getResource(right);
        }
        if (resource != null) {
            return resource.getName();
        }
        return left != null ? left.getName() : right.getName();
    }

    static void setLabels(CompareEditorInput compareEditorInput, ITypedElement left, ITypedElement right, BazaarRevision leftRevision, BazaarRevision rightRevision) {
        String leftRevisionName = CompareEditorUtil.getRevisionName(left, leftRevision);
        String rightRevisionName = CompareEditorUtil.getRevisionName(right, rightRevision);
        String resourceName = CompareEditorUtil.getResourceName(left, right);
        if (leftRevisionName == null) {
            leftRevisionName = UITexts.CompareWith_workspace;
        }
        if (rightRevisionName == null) {
            rightRevisionName = UITexts.CompareWith_latest;
        }
        String title = UITexts.bind(UITexts.CompareWith_title, new String[]{resourceName, leftRevisionName, rightRevisionName});
        String leftLabel = UITexts.bind("{0}", new String[]{leftRevisionName});
        String rightLabel = UITexts.bind("{0}", new String[]{rightRevisionName});
        CompareConfiguration cc = compareEditorInput.getCompareConfiguration();
        compareEditorInput.setTitle(title);
        cc.setLeftLabel(leftLabel);
        cc.setRightLabel(rightLabel);
    }
}

