/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.compare;

import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.resources.IStorageBazaarRevision;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.compare.BazaarCompareEditorInput;
import org.vcs.bazaar.eclipse.ui.compare.BazaarResourceNode;
import org.vcs.bazaar.eclipse.ui.compare.BazaarRevisionNode;
import org.vcs.bazaar.eclipse.ui.compare.BazaarStatusBasedCompareEditorInput;
import org.vcs.bazaar.eclipse.ui.compare.SaveableBazaarCompareEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareUtils {
    public static void openDialog(IResource file) {
        CompareEditorInput editorInput = CompareUtils.getEditorInput(new BazaarResourceNode(file), CompareUtils.getNode(file, new IStorageBazaarRevision(file)));
        CompareUI.openCompareDialog((CompareEditorInput)editorInput);
    }

    public static void openEditor(IResource resource, IStorageBazaarRevision left, IStorageBazaarRevision right) {
        CompareEditorInput editorInput = CompareUtils.getEditorInput(CompareUtils.getNode(resource, left), CompareUtils.getNode(resource, right));
        CompareUtils.openOrReuseCompareEditor(null, editorInput);
    }

    public static void openSaveableEditor(IResource left, IStorageBazaarRevision right, IWorkbenchPage page) {
        SaveableBazaarCompareEditorInput editorInput = new SaveableBazaarCompareEditorInput(new BazaarResourceNode(left), CompareUtils.getNode(left, right), page);
        CompareUtils.openOrReuseCompareEditor(page, (CompareEditorInput)editorInput);
    }

    private static CompareEditorInput getEditorInput(BazaarResourceNode left, BazaarResourceNode right) {
        return new BazaarCompareEditorInput(left, right);
    }

    private static BazaarRevisionNode getNode(IResource resource, IStorageBazaarRevision rev) {
        return rev == null ? null : new BazaarRevisionNode(resource, rev);
    }

    public static void openStructuredCompareEditor(IResource[] resources, List<IBzrResourceStatus> localResources, BazaarRevision leftRevision, BazaarRevision rightRevision, IWorkbenchPage activePage) {
        BazaarStatusBasedCompareEditorInput editorInput = new BazaarStatusBasedCompareEditorInput(resources, localResources, leftRevision, rightRevision, activePage);
        CompareUtils.openOrReuseCompareEditor(activePage, editorInput);
    }

    private static void openOrReuseCompareEditor(IWorkbenchPage activePage, CompareEditorInput editorInput) {
        IReusableEditor editor;
        if (activePage == null) {
            activePage = EclipseBazaarUI.getActivePage();
        }
        if ((editor = CompareUtils.findReusableCompareEditor(editorInput, activePage)) != null) {
            CompareUI.reuseCompareEditor((CompareEditorInput)editorInput, (IReusableEditor)editor);
            activePage.activate((IWorkbenchPart)editor);
        } else {
            CompareUI.openCompareEditorOnPage((CompareEditorInput)editorInput, (IWorkbenchPage)activePage);
        }
    }

    public static IReusableEditor findReusableCompareEditor(CompareEditorInput input, IWorkbenchPage page) {
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && part instanceof IReusableEditor && input.equals(part.getEditorInput())) {
                return (IReusableEditor)part;
            }
            ++i;
        }
        return null;
    }
}

