/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.console;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.vcs.bazaar.client.IBazaarNotifyListener;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.client.IConsoleListener;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.console.ConsoleDocument;

public class BzrOutputConsole
extends IOConsole
implements IConsoleListener,
IPropertyChangeListener {
    public static final String BZR_CONSOLE_TYPE = "BZR";
    private IOConsoleOutputStream commandStream;
    private IOConsoleOutputStream messageStream;
    private IOConsoleOutputStream errorStream;
    private IOConsoleOutputStream debugStream;
    private boolean showOnDebug;
    private boolean showOnMessage = EclipseBazaarUI.getDefault().getPreferenceStore().getBoolean("pref_console_show_on_message");
    private boolean showOnError = EclipseBazaarUI.getDefault().getPreferenceStore().getBoolean("pref_console_show_on_error");
    private ConsoleDocument document;
    private boolean visible = false;
    private boolean initialized = false;

    public BzrOutputConsole() {
        super("Bazaar", BZR_CONSOLE_TYPE, EclipseBazaarUI.getImageDescriptor("icons/bzrlogo.png"));
        this.showOnDebug = EclipseBazaarUI.getDefault().getPreferenceStore().getBoolean("pref_console_show_on_debug");
        this.document = new ConsoleDocument();
        EclipseBazaarCore.getDefault().setConsoleListener((IBazaarNotifyListener)this);
        EclipseBazaarUI.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void init() {
        super.init();
        this.initLimitOutput();
        EclipseBazaarUI.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)BzrOutputConsole.this);
                BzrOutputConsole.this.initializeStreams();
                BzrOutputConsole.this.dump();
            }
        });
    }

    private void initLimitOutput() {
        IPreferenceStore store = EclipseBazaarUI.getDefault().getPreferenceStore();
        if (store.getBoolean("pref_console_limit_output")) {
            this.setWaterMarks(1000, store.getInt("pref_console_high_water_mark"));
        } else {
            this.setWaterMarks(-1, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStreams() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (!this.initialized) {
                this.commandStream = this.newOutputStream();
                this.errorStream = this.newOutputStream();
                this.messageStream = this.newOutputStream();
                this.debugStream = this.newOutputStream();
                this.setFont(JFaceResources.getFontRegistry().get("pref_console_font"));
                this.initialized = true;
                Color newColor = this.createColor(EclipseBazaarUI.getStandardDisplay(), "pref_console_command_color");
                this.commandStream.setColor(newColor);
                newColor = this.createColor(EclipseBazaarUI.getStandardDisplay(), "pref_console_message_color");
                this.messageStream.setColor(newColor);
                newColor = this.createColor(EclipseBazaarUI.getStandardDisplay(), "pref_console_error_color");
                this.errorStream.setColor(newColor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            ConsoleDocument.ConsoleLine[] lines;
            this.visible = true;
            ConsoleDocument.ConsoleLine[] consoleLineArray = lines = this.document.getLines();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleDocument.ConsoleLine line = consoleLineArray[n2];
                this.appendLine(line.type, line.line);
                ++n2;
            }
            this.document.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendLine(int type, String line) {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            if (this.visible) {
                try {
                    switch (type) {
                        case 0: {
                            this.commandStream.write(line);
                            this.commandStream.write(System.getProperty("line.separator"));
                            break;
                        }
                        case 1: {
                            this.messageStream.write("  " + line);
                            this.messageStream.write(System.getProperty("line.separator"));
                            break;
                        }
                        case 2: {
                            this.errorStream.write(System.getProperty("line.separator"));
                            this.errorStream.write("  " + line);
                            break;
                        }
                        case 3: {
                            this.debugStream.write("  " + line);
                            this.debugStream.write(System.getProperty("line.separator"));
                            break;
                        }
                        case 5: {
                            this.messageStream.write(line);
                            this.messageStream.write(System.getProperty("line.separator"));
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    EclipseBazaarUI.log(e.getMessage(), e);
                }
            } else {
                this.document.appendConsoleLine(type, line);
            }
        }
    }

    private void bringConsoleToFront() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        if (!this.visible) {
            manager.addConsoles(new IConsole[]{this});
        }
        manager.showConsoleView((IConsole)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        ConsoleDocument consoleDocument = this.document;
        synchronized (consoleDocument) {
            this.visible = false;
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public void shutdown() {
        super.dispose();
        EclipseBazaarUI.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object value;
        String property = event.getProperty();
        if (this.visible) {
            Color newColor;
            if ("pref_console_command_color".equals(property)) {
                newColor = this.createColor(EclipseBazaarUI.getStandardDisplay(), "pref_console_command_color");
                this.commandStream.setColor(newColor);
            } else if ("pref_console_message_color".equals(property)) {
                newColor = this.createColor(EclipseBazaarUI.getStandardDisplay(), "pref_console_message_color");
                this.messageStream.setColor(newColor);
            } else if ("pref_console_error_color".equals(property)) {
                newColor = this.createColor(EclipseBazaarUI.getStandardDisplay(), "pref_console_error_color");
                this.errorStream.setColor(newColor);
            } else if ("pref_console_font".equals(property)) {
                this.setFont(JFaceResources.getFontRegistry().get("pref_console_font"));
            } else if ("pref_console_limit_output".equals(property)) {
                this.initLimitOutput();
            }
        }
        if ("pref_console_show_on_message".equals(property)) {
            value = event.getNewValue();
            this.showOnMessage = value instanceof String ? Boolean.getBoolean((String)event.getNewValue()) : (Boolean)value;
        }
        if ("pref_console_show_on_error".equals(property)) {
            value = event.getNewValue();
            this.showOnError = value instanceof String ? Boolean.getBoolean((String)event.getNewValue()) : (Boolean)value;
        }
        if ("pref_console_show_on_debug".equals(property)) {
            value = event.getNewValue();
            this.showOnDebug = value instanceof String ? Boolean.getBoolean((String)event.getNewValue()) : (Boolean)value;
        }
    }

    private Color createColor(Display display, String preference) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)EclipseBazaarUI.getDefault().getPreferenceStore(), (String)preference);
        return new Color((Device)display, rgb);
    }

    public void logCommandLine(String commandLine) {
        if (this.showOnMessage) {
            this.bringConsoleToFront();
        }
        this.appendLine(5, UITexts.BazaarConsole_delimiter);
        this.appendLine(0, commandLine);
    }

    public void logMessage(String message) {
        if (this.showOnMessage) {
            this.bringConsoleToFront();
        }
        this.appendLine(1, "  " + message);
    }

    public void logRevision(long revision, String path) {
    }

    public void logCompleted(String message) {
        if (this.showOnMessage) {
            this.bringConsoleToFront();
        }
        this.appendLine(1, "  " + message);
    }

    public void logError(String message) {
        if (this.showOnMessage || this.showOnError) {
            this.bringConsoleToFront();
        }
        this.appendLine(2, "  " + message);
    }

    public void logCommandOutput(String message) {
        if (this.showOnDebug) {
            this.bringConsoleToFront();
            this.appendLine(3, "  " + message);
        }
    }

    public void onNotify(File path) {
    }

    public void setCommand(int command) {
    }

    class MyLifecycle
    implements org.eclipse.ui.console.IConsoleListener {
        MyLifecycle() {
        }

        public void consolesAdded(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console == BzrOutputConsole.this) {
                    BzrOutputConsole.this.init();
                }
                ++n2;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console == BzrOutputConsole.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((org.eclipse.ui.console.IConsoleListener)this);
                    BzrOutputConsole.this.dispose();
                }
                ++n2;
            }
        }
    }
}

