/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.console;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.UITexts;

public class ConsolePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor commandColorEditor;
    private ColorFieldEditor messageColorEditor;
    private ColorFieldEditor errorColorEditor;
    private BooleanFieldEditor showOnDebug;
    private BooleanFieldEditor showOnMessage;
    private BooleanFieldEditor showOnError;
    private BooleanFieldEditor restrictOutput;
    private IntegerFieldEditor highWaterMark;

    public ConsolePreferencesPage() {
        super(1);
        this.setPreferenceStore(EclipseBazaarUI.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        IPreferenceStore store = this.getPreferenceStore();
        this.restrictOutput = new BooleanFieldEditor("pref_console_limit_output", UITexts.BazaarConsole_preferences_limitOutput, composite);
        this.addField((FieldEditor)this.restrictOutput);
        this.highWaterMark = new IntegerFieldEditor("pref_console_high_water_mark", UITexts.BazaarConsole_preferences_highWaterMark, composite);
        this.highWaterMark.setValidRange(1000, 0x7FFFFFFE);
        this.addField((FieldEditor)this.highWaterMark);
        this.highWaterMark.setEnabled(store.getBoolean("pref_console_limit_output"), composite);
        this.showOnMessage = new BooleanFieldEditor("pref_console_show_on_message", UITexts.BazaarConsole_preferences_showOnMessage, composite);
        this.addField((FieldEditor)this.showOnMessage);
        this.showOnError = new BooleanFieldEditor("pref_console_show_on_error", UITexts.BazaarConsole_preferences_showOnError, composite);
        this.addField((FieldEditor)this.showOnError);
        this.showOnDebug = new BooleanFieldEditor("pref_console_show_on_debug", UITexts.BazaarConsole_preferences_showOnDebug, composite);
        this.addField((FieldEditor)this.showOnDebug);
        this.createLabel(composite, UITexts.BazaarConsole_preferences_consoleColorSettings);
        this.commandColorEditor = this.createColorFieldEditor("pref_console_command_color", UITexts.BazaarConsole_preferences_commandColor, composite);
        this.addField((FieldEditor)this.commandColorEditor);
        this.messageColorEditor = this.createColorFieldEditor("pref_console_message_color", UITexts.BazaarConsole_preferences_messageColor, composite);
        this.addField((FieldEditor)this.messageColorEditor);
        this.errorColorEditor = this.createColorFieldEditor("pref_console_error_color", UITexts.BazaarConsole_preferences_errorColor, composite);
        this.addField((FieldEditor)this.errorColorEditor);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        this.highWaterMark.setEnabled(this.restrictOutput.getBooleanValue(), this.getFieldEditorParent());
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    private ColorFieldEditor createColorFieldEditor(String preferenceName, String label, Composite parent) {
        ColorFieldEditor editor = new ColorFieldEditor(preferenceName, label, parent);
        editor.setPage((DialogPage)this);
        editor.setPreferenceStore(this.getPreferenceStore());
        return editor;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        EclipseBazaarUI.getDefault().savePluginPreferences();
        return super.performOk();
    }
}

