/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.credentials;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.widgets.Shell;
import org.vcs.bazaar.client.IBazaarPromptUserPassword;
import org.vcs.bazaar.client.IBazaarUserPassword;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.credentials.BazaarCredentials;
import org.vcs.bazaar.eclipse.core.credentials.SecureCredentialsStoreException;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.dialogs.LoginDialog;

public class BazaarCredentialsProvider
implements IBazaarPromptUserPassword {
    public IBazaarUserPassword getCredentials(final String location, final boolean passwordOnly, boolean changeStored) {
        if (!changeStored) {
            BazaarCredentials credentials = null;
            try {
                credentials = EclipseBazaarCore.getDefault().getSecureCredentialsStore().getCredentials(location);
            }
            catch (SecureCredentialsStoreException secureCredentialsStoreException) {}
            if (credentials != null && credentials.getPassword() != null && (passwordOnly || credentials.getUser() != null)) {
                return credentials;
            }
        }
        final AtomicReference<Object> aRef = new AtomicReference<Object>(null);
        EclipseBazaarUI.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                Shell shell = EclipseBazaarUI.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                LoginDialog dialog = new LoginDialog(shell, location, passwordOnly);
                if (dialog.open() == 0) {
                    BazaarCredentials credentials = dialog.getCredentials();
                    if (credentials != null && dialog.getStoreInSecureStore()) {
                        try {
                            EclipseBazaarCore.getDefault().getSecureCredentialsStore().putCredentials(location, credentials);
                        }
                        catch (SecureCredentialsStoreException secureCredentialsStoreException) {}
                    }
                    aRef.set(credentials);
                }
            }
        });
        return aRef.get();
    }
}

