/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.decorator;

import java.text.DateFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.listeners.BzrChangeStateEvent;
import org.vcs.bazaar.eclipse.core.listeners.IResourceStateListener;
import org.vcs.bazaar.eclipse.core.model.BzrStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;
import org.vcs.bazaar.eclipse.ui.decorator.DecoratorImages;
import org.vcs.bazaar.eclipse.ui.decorator.DecoratorTextLabels;

public class BazaarLightweightDecorator
extends LabelProvider
implements ILightweightLabelDecorator,
IResourceStateListener,
IPropertyChangeListener {
    public static final DateFormat dateFormat = DateFormat.getInstance();
    private final IPreferenceStore store = EclipseBazaarUI.getDefault().getPreferenceStore();

    public BazaarLightweightDecorator() {
        EclipseBazaarCore.addResourceStateListener((IResourceStateListener)this);
        TeamUI.addPropertyChangeListener((IPropertyChangeListener)this);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().addPropertyChangeListener((IPropertyChangeListener)this);
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
        this.ensureFontAndColorsCreated();
    }

    public static void refresh() {
        EclipseBazaarCore.getDefault().getStatusCacheManager().setLogCacheEnabled(EclipseBazaarUI.getDefault().getPreferenceStore().getBoolean("pref_file_text_decorator_enabled"));
        EclipseBazaarUI.getDefault().getWorkbench().getDecoratorManager().update(BazaarLightweightDecorator.class.getName());
    }

    public void decorate(Object element, IDecoration decoration) {
        IProject project;
        IResource resource = (IResource)element;
        if (resource.isAccessible() && !resource.isLinked(512) && !resource.isDerived() && !resource.isTeamPrivateMember() && (project = resource.getProject()) != null && RepositoryProvider.isShared((IProject)project) && BazaarLightweightDecorator.getRepositoryProvider(resource) != null) {
            this.decorate(resource, project, decoration);
        }
    }

    private boolean isInsideMetaFolder(IResource objectResource) {
        String[] stringArray = objectResource.getLocation().segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (".bzr".equals(segment)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void decorate(IResource objectResource, IProject objectProject, IDecoration decoration) {
        block4: {
            if (objectResource.isAccessible() && !this.isInsideMetaFolder(objectResource) && !objectResource.isLinked(512) && !objectResource.isDerived(512)) {
                try {
                    this.decorateByType(objectResource, decoration);
                }
                catch (CoreException e) {
                    EclipseBazaarUI.log(e);
                }
                catch (RuntimeException e) {
                    EclipseBazaarUI.traceException("label_decorator", e);
                    if (!objectProject.isOpen()) break block4;
                    EclipseBazaarUI.log("Unexpected error while decorating: " + objectResource.getName(), e);
                }
            }
        }
    }

    private void decorateByType(IResource resource, IDecoration decoration) throws CoreException {
        IBazaarLogMessage logMessage;
        IBzrLocalResource bzrResource = BzrWorkspaceRoot.getBzrResourceFor((IResource)resource);
        BzrStatus status = bzrResource.getStatus();
        if (resource.getType() == 4) {
            String nick;
            if (this.store.getBoolean("pref_project_decorator_enabled") && (nick = bzrResource.getBranch().getNick()) != null) {
                decoration.addSuffix("  [" + nick + "]");
            }
        } else if (status != null && !status.isAdded() && !status.isUnknown() && !status.isIgnored() && this.store.getBoolean("pref_file_text_decorator_enabled") && (logMessage = BazaarLightweightDecorator.getLastLogMessage(resource)) != null) {
            decoration.addSuffix("  " + logMessage.getRevision().getValue() + " " + logMessage.getCommiter() + " " + dateFormat.format(logMessage.getDate()));
        }
        if (status != null) {
            if (this.store.getBoolean("pref_status_text_decorator_enabled")) {
                decoration.addPrefix(DecoratorTextLabels.getStatusTextLabel(status));
            }
            if (this.store.getBoolean("pref_status_overlay_decorator_enabled")) {
                decoration.addOverlay(DecoratorImages.getImageDescriptor(status));
            }
            this.decorateFontAndColour(status, decoration);
        }
    }

    private void decorateFontAndColour(BzrStatus status, IDecoration decoration) {
        if (status.isAnyModifiedStatus()) {
            ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            Color bc = current.getColorRegistry().get("org.vcs.bazaar.eclipse.ui.UncommittedChangeBackgroundColor");
            Color fc = current.getColorRegistry().get("org.vcs.bazaar.eclipse.ui.UncommittedChangeForegroundColor");
            Font f = current.getFontRegistry().get("org.vcs.bazaar.eclipse.ui.UncommittedChangeFont");
            decoration.setBackgroundColor(bc);
            decoration.setForegroundColor(fc);
            decoration.setFont(f);
        }
    }

    private void ensureFontAndColorsCreated() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                theme.getColorRegistry().get("org.vcs.bazaar.eclipse.ui.UncommittedChangeForegroundColor");
                theme.getColorRegistry().get("org.vcs.bazaar.eclipse.ui.UncommittedChangeBackgroundColor");
                theme.getFontRegistry().get("org.vcs.bazaar.eclipse.ui.UncommittedChangeFont");
            }
        });
    }

    public void dispose() {
        super.dispose();
        EclipseBazaarCore.removeResourceStateListener((IResourceStateListener)this);
        TeamUI.removePropertyChangeListener((IPropertyChangeListener)this);
        PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().removePropertyChangeListener((IPropertyChangeListener)this);
        this.store.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void resourceStateChanged(BzrChangeStateEvent event) {
        this.postLabelChangeEvent();
    }

    private static BazaarTeamProvider getRepositoryProvider(IResource resource) {
        RepositoryProvider repoProvider = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (!(repoProvider instanceof BazaarTeamProvider)) {
            return null;
        }
        if (((BazaarTeamProvider)repoProvider).getBzrWorkspaceRoot() == null) {
            return null;
        }
        return (BazaarTeamProvider)repoProvider;
    }

    private static IBazaarLogMessage getLastLogMessage(IResource resource) throws CoreException {
        return EclipseBazaarCore.getDefault().getStatusCacheManager().getLastLog(resource);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if (prop.equals("org.eclipse.team.uiglobal_ignores_changed") || prop.equals("org.eclipse.team.uiglobal_file_types_changed")) {
            this.postLabelChangeEvent();
        } else if (prop.equals("org.vcs.bazaar.eclipse.ui.UncommittedChangeForegroundColor") || prop.equals("org.vcs.bazaar.eclipse.ui.UncommittedChangeBackgroundColor") || prop.equals("org.vcs.bazaar.eclipse.ui.UncommittedChangeFont")) {
            this.ensureFontAndColorsCreated();
            this.postLabelChangeEvent();
        }
    }

    private void postLabelChangeEvent() {
        LabelEventJob.getInstance().postLabelEvent(this);
    }

    private void fireLabelChangeEvent() {
        final LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                BazaarLightweightDecorator.this.fireLabelProviderChanged(event);
            }
        });
    }

    private static class LabelEventJob
    extends Job {
        private static final long DELAY = 100L;
        private static LabelEventJob instance = new LabelEventJob("LabelEventJob");
        private BazaarLightweightDecorator decorator = null;

        static LabelEventJob getInstance() {
            return instance;
        }

        private LabelEventJob(String name) {
            super(name);
        }

        void postLabelEvent(BazaarLightweightDecorator decorator) {
            this.decorator = decorator;
            if (this.getState() == 1 || this.getState() == 2) {
                this.cancel();
            }
            this.schedule(100L);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.decorator != null) {
                this.decorator.fireLabelChangeEvent();
            }
            return Status.OK_STATUS;
        }
    }
}

