/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.decorator;

import java.util.HashMap;
import java.util.Map;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.eclipse.core.model.BzrStatus;
import org.vcs.bazaar.eclipse.ui.decorator.DecoratorResources;

public class DecoratorTextLabels
extends DecoratorResources {
    public static final String addedPrefix = "+ ";
    public static final String deletedStillTrackedPrefix = "- ";
    public static final String ignoredPrefix = "I ";
    public static final String modifiedPrefix = "> ";
    public static final String notTrackedPrefix = "? ";
    public static final String removedPrefix = "- ";
    public static final String managedPrefix = "";
    public static final String conflictPrefix = "C ";
    public static final String renamePrefix = "R ";
    private static final Map<BazaarStatusKind, String> labelMap = new HashMap<BazaarStatusKind, String>(9);

    static {
        labelMap.put(BazaarStatusKind.CREATED, addedPrefix);
        labelMap.put(BazaarStatusKind.MODIFIED, modifiedPrefix);
        labelMap.put(BazaarStatusKind.UNKNOWN, notTrackedPrefix);
        labelMap.put(BazaarStatusKind.DELETED, "- ");
        labelMap.put(BazaarStatusKind.UNCHANGED, managedPrefix);
        labelMap.put(BazaarStatusKind.HAS_CONFLICTS, conflictPrefix);
        labelMap.put(BazaarStatusKind.RENAMED, renamePrefix);
    }

    public static final String getStatusTextLabel(BzrStatus status) {
        BazaarStatusKind kind = DecoratorTextLabels.getStatusFlagKind(status);
        if (kind != null) {
            String value = labelMap.get(kind);
            return value == null ? String.valueOf(String.valueOf(kind.toChar())) + " " : value;
        }
        return managedPrefix;
    }
}

