/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.ICommitOptions;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.core.history.BazaarFileHistory;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.UIUtils;
import org.vcs.bazaar.eclipse.ui.actions.CommitAction;
import org.vcs.bazaar.eclipse.ui.dialogs.CommitMessageArea;
import org.vcs.bazaar.eclipse.ui.dialogs.CommitMessageContentProposalProcessor;
import org.vcs.bazaar.eclipse.ui.dialogs.CommitMessageHistory;
import org.vcs.bazaar.eclipse.ui.dialogs.SpellcheckableMessageArea;
import org.vcs.bazaar.eclipse.ui.history.HistoryTreeViewer;
import org.vcs.bazaar.eclipse.ui.widgets.BzrResourceSelectionComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitDialog
extends TrayDialog {
    private static final int COMMIT_AND_PUSH_ID = 3;
    private static HistoryTreeViewer.Column[] columns = new HistoryTreeViewer.Column[]{HistoryTreeViewer.Column.REVID, HistoryTreeViewer.Column.COMMITTER, HistoryTreeViewer.Column.TIMESTAMP, HistoryTreeViewer.Column.MESSAGE};
    private SpellcheckableMessageArea commitText;
    private Group optionGroup;
    private Label commitTextLabel;
    private Button localCommitButton;
    private CommitAction.CommitableResources commitableResources;
    private List<IBzrResourceStatus> selectedFiles;
    private String commitMessage;
    private boolean pushAfterCommit;
    private CommitAction.CommitableResources selectedResources;
    private Text authorText;
    private BzrResourceSelectionComposite resourceSelectionComposite;
    private Text fixesText;
    private ArrayList<Option> options = new ArrayList(0);
    private boolean pendingMerge;
    private final BranchLocation pushLocation;

    public CommitDialog(Shell shell, BranchLocation pushLocation) {
        super(shell);
        this.setShellStyle(3184);
        this.setBlockOnOpen(false);
        this.pushLocation = pushLocation;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public List<IBzrResourceStatus> getSelectedFiles() {
        return this.selectedFiles;
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
        this.getButton(3).setEnabled(false);
        if (this.pushLocation != null) {
            this.getButton(3).setToolTipText(this.pushLocation.toString());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.getShell().setText(UITexts.CommitDialog_dialogTitle);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Composite messageArea = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().applyTo(messageArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)messageArea);
        this.commitTextLabel = new Label(messageArea, 0);
        this.commitTextLabel.setText(UITexts.CommitDialog_commentsTitle);
        this.commitText = new CommitMessageArea(messageArea, "", 2048){

            protected CommitMessageContentProposalProcessor getCommitProposalProcessor() {
                return new CommitMessageContentProposalProcessor(CommitDialog.this.commitableResources.getAllStatuses());
            }
        };
        GridData textBoxData = new GridData(768);
        textBoxData.heightHint = 150;
        this.commitText.setLayoutData(textBoxData);
        UIUtils.addBulbDecorator((Control)this.commitText.getTextWidget(), UITexts.CommitDialog_contentAssist);
        this.commitText.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                CommitDialog.this.enableOkButton();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        Composite textArea = new Composite(container, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(textArea);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textArea);
        this.createAuthorTextBox(textArea);
        this.createFixesTextBox(textArea);
        this.resourceSelectionComposite = new BzrResourceSelectionComposite(!this.pendingMerge, !this.pendingMerge){

            protected void createOption(Composite container) {
                CommitDialog.this.optionGroup = new Group(container, 0);
                CommitDialog.this.optionGroup.setText(UITexts.Dialog_optionsGroup);
                CommitDialog.this.optionGroup.setLayout((Layout)new GridLayout(3, false));
                GridData data = new GridData();
                data.horizontalAlignment = 4;
                data.verticalAlignment = 3;
                data.grabExcessHorizontalSpace = true;
                data.grabExcessVerticalSpace = true;
                CommitDialog.this.optionGroup.setLayoutData((Object)data);
                CommitDialog.this.localCommitButton = new Button((Composite)CommitDialog.this.optionGroup, 32);
                CommitDialog.this.localCommitButton.setText(UITexts.CommitDialog_localCommit);
            }

            protected String getUpperLabel() {
                if (!CommitDialog.this.pendingMerge) {
                    return "Select Files:";
                }
                return "";
            }

            protected void createMiddleControls(Composite container) {
                if (CommitDialog.this.pendingMerge) {
                    TabFolder folder = new TabFolder(container, 0);
                    folder.setLayoutData((Object)new GridData(4, 4, true, true));
                    TabItem fileListItem = new TabItem(folder, 0);
                    fileListItem.setText("File list");
                    super.createMiddleControls((Composite)folder);
                    fileListItem.setControl((Control)super.getTableViewer().getControl().getParent());
                    TabItem logItem = new TabItem(folder, 0);
                    HistoryTreeViewer tv = new HistoryTreeViewer((Composite)folder, columns);
                    logItem.setControl((Control)tv.getControl().getParent());
                    logItem.setText("Pending merges");
                    tv.setInput(new BazaarFileHistory(CommitDialog.this.commitableResources.getAllPendingMerges()));
                } else {
                    super.createMiddleControls(container);
                }
            }
        };
        Composite listComposite = this.resourceSelectionComposite.createControls(container);
        this.resourceSelectionComposite.getTableViewer().addFilter((ViewerFilter)new CommittableFilesFilter());
        this.resourceSelectionComposite.setResources(this.commitableResources.getAllStatuses());
        if (this.pendingMerge) {
            ArrayList<IBzrResourceStatus> filteredResources = new ArrayList<IBzrResourceStatus>(this.commitableResources.getAllStatuses().size());
            for (IBzrResourceStatus status : this.commitableResources.getAllStatuses()) {
                if (status.isUnknown()) continue;
                filteredResources.add(status);
            }
            this.resourceSelectionComposite.setSelection(filteredResources);
            this.resourceSelectionComposite.addUntrackedFilesFilter();
        } else {
            this.resourceSelectionComposite.setSelection(this.selectedResources.getAllStatuses());
            this.resourceSelectionComposite.addUntrackedFilesFilterIfNoUntrackedSelected();
        }
        this.resourceSelectionComposite.refreshTableViewer();
        this.resourceSelectionComposite.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CommitDialog.this.enableOkButton();
            }
        });
        listComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.makeActions();
        return container;
    }

    private void createAuthorTextBox(Composite parent) {
        final Composite container = parent;
        Label author = new Label(container, 256);
        author.setText("Author:");
        this.authorText = new Text(container, 2116);
        this.authorText.setLayoutData((Object)new GridData(768));
        container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point currSize = CommitDialog.this.authorText.getSize();
                currSize.x = container.getSize().x;
                CommitDialog.this.authorText.setSize(currSize);
            }
        });
    }

    private void createFixesTextBox(Composite parent) {
        final Composite container = parent;
        Label author = new Label(container, 256);
        author.setText("Fixes:");
        this.fixesText = new Text(container, 2116);
        this.fixesText.setLayoutData((Object)new GridData(768));
        container.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point currSize = CommitDialog.this.fixesText.getSize();
                currSize.x = container.getSize().x;
                CommitDialog.this.fixesText.setSize(currSize);
            }
        });
    }

    private void makeActions() {
        this.commitText.setCapture(true);
        this.localCommitButton.setSelection(false);
        boolean localCommitAllowed = false;
        for (IBzrResourceStatus commitable : this.commitableResources.getAllStatuses()) {
            if (commitable.isDeleted() || !commitable.getResource().getBranch().isBound()) continue;
            localCommitAllowed = true;
            break;
        }
        GridData data = (GridData)this.optionGroup.getLayoutData();
        data.exclude = !localCommitAllowed;
        this.optionGroup.setVisible(localCommitAllowed);
    }

    private void enableOkButton() {
        String text = this.commitText.getText();
        boolean enabled = text != null && !text.trim().isEmpty();
        this.getButton(0).setEnabled(enabled &= !this.resourceSelectionComposite.getSelection().isEmpty() || this.pendingMerge);
        this.getButton(3).setEnabled(enabled);
    }

    protected void okPressed() {
        this.selectedFiles = this.resourceSelectionComposite.getSelection();
        this.commitMessage = this.commitText.getText();
        String author = this.authorText.getText();
        String fixes = this.fixesText.getText();
        this.options = new ArrayList(0);
        if (this.localCommitButton.getSelection()) {
            this.options.add(ICommitOptions.LOCAL);
        }
        if (author != null && !author.trim().isEmpty()) {
            this.options.add((Option)ICommitOptions.AUTHOR.setArgument(author));
        }
        if (fixes != null && !fixes.trim().isEmpty()) {
            this.options.add((Option)ICommitOptions.FIXES.setArgument(fixes));
        }
        CommitMessageHistory.saveCommitHistory(this.commitMessage);
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(700, 700);
    }

    public boolean isPushAfterCommit() {
        return this.pushAfterCommit;
    }

    public ArrayList<Option> getOptions() {
        return this.options;
    }

    public int open(CommitAction.CommitableResources commitableResources, CommitAction.CommitableResources selectedResources, boolean shouldBlock) {
        this.setShellStyle(3184);
        this.setBlockOnOpen(shouldBlock);
        this.commitableResources = commitableResources;
        this.selectedResources = selectedResources;
        this.pendingMerge = commitableResources.getAllPendingMerges().size() > 0;
        return this.open();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 3, UITexts.CommitDialog_commitAndPush, false);
        this.createButton(parent, 0, UITexts.CommitDialog_commit, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 3) {
            this.pushAfterCommit = true;
            this.okPressed();
        } else {
            this.pushAfterCommit = false;
            super.buttonPressed(buttonId);
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setMinimumSize(280, 400);
        CommitDialog dialog = new CommitDialog(shell, null);
        int exit = dialog.open(new CommitAction.CommitableResources(), new CommitAction.CommitableResources(), true);
        System.out.println("exit: " + exit);
    }

    private class CommittableFilesFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IBzrResourceStatus) {
                IBzrResourceStatus status = (IBzrResourceStatus)element;
                IBzrLocalResource bzrResource = status.getResource();
                if (status.isUnchanged() || status.isIgnored() || !status.isDeleted() && bzrResource.getIResource().getType() == 4) {
                    return false;
                }
            }
            return true;
        }
    }
}

