/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.vcs.bazaar.eclipse.core.model.IBzrResourceStatus;
import org.vcs.bazaar.eclipse.ui.UIIcons;
import org.vcs.bazaar.eclipse.ui.UIUtils;
import org.vcs.bazaar.eclipse.ui.dialogs.CommitMessageHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitMessageContentProposalProcessor
implements IContentAssistProcessor {
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private final LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private List<Proposal> fileProposals;

    public CommitMessageContentProposalProcessor(List<IBzrResourceStatus> statuses) {
        TreeSet<String> sortedFiles = new TreeSet<String>();
        for (IBzrResourceStatus status : statuses) {
            sortedFiles.add(status.getResource().getFile().getName());
        }
        ArrayList<Proposal> proposals = new ArrayList<Proposal>();
        for (String file : sortedFiles) {
            proposals.add(new Proposal(file, (Image)this.resourceManager.get((DeviceResourceDescriptor)UIUtils.getEditorImage(file))));
        }
        this.fileProposals = proposals;
    }

    private String getPrefix(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        int start = offset - 1;
        while (start >= 0 && !Character.isWhitespace(doc.getChar(start))) {
            --start;
            ++length;
        }
        return doc.get(start + 1, length);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        try {
            prefix = this.getPrefix(viewer, offset);
        }
        catch (BadLocationException badLocationException) {
            return NO_PROPOSALS;
        }
        prefix = prefix == null ? "" : prefix;
        int replacementLength = prefix.length();
        int replacementOffset = offset - replacementLength;
        prefix = prefix.toLowerCase();
        List<Proposal> proposals = this.getTemplateProposals();
        proposals.addAll(this.getMessageProposals());
        if (!prefix.isEmpty()) {
            proposals.addAll(this.getFileProposals());
        }
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        for (Proposal item : proposals) {
            if (!item.matches(prefix)) continue;
            result.add(new CompletionProposal(item.getText(), replacementOffset, replacementLength, item.getText().length(), item.getIcon(), item.getLabel(), null, null));
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private List<Proposal> getMessageProposals() {
        ArrayList<Proposal> proposals = new ArrayList<Proposal>();
        for (String messge : CommitMessageHistory.getCommitHistory()) {
            proposals.add(new Proposal(messge, (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.COMMENT)));
        }
        return proposals;
    }

    private List<Proposal> getFileProposals() {
        return this.fileProposals;
    }

    private List<Proposal> getTemplateProposals() {
        ArrayList<Proposal> proposals = new ArrayList<Proposal>();
        for (String messge : CommitMessageHistory.getTemplates()) {
            proposals.add(new Proposal(messge, (Image)this.resourceManager.get((DeviceResourceDescriptor)UIIcons.TEMPLATE)));
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public void dispose() {
        this.resourceManager.dispose();
    }

    private static class Proposal {
        private final String text;
        private final Image icon;

        protected Proposal(String text, Image icon) {
            this.text = text;
            this.icon = icon;
        }

        public boolean matches(String prefix) {
            return this.text.toLowerCase().startsWith(prefix);
        }

        public String getLabel() {
            return UIUtils.getFirstLine(this.text);
        }

        public String getText() {
            return this.text;
        }

        public Image getIcon() {
            return this.icon;
        }
    }
}

