/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.vcs.bazaar.eclipse.ui.EclipseBazaarUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitMessageHistory {
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_MESSAGES = "messages";

    public static Set<String> getCommitHistory() {
        return CommitMessageHistory.getMessages("commit_dialog_history_messages");
    }

    public static Set<String> getTemplates() {
        return CommitMessageHistory.getMessages("commit_dialog_templates");
    }

    public static Set<String> getMessages(String preferenceKey) {
        XMLMemento memento;
        String all = CommitMessageHistory.getPreferenceStore().getString(preferenceKey);
        if (all.length() == 0) {
            return Collections.emptySet();
        }
        int max = CommitMessageHistory.getCommitHistorySize();
        if (max < 1) {
            return Collections.emptySet();
        }
        try {
            memento = XMLMemento.createReadRoot((Reader)new StringReader(all));
        }
        catch (WorkbenchException workbenchException) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> messages = new LinkedHashSet<String>();
        IMemento[] iMementoArray = memento.getChildren(KEY_MESSAGE);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            messages.add(child.getTextData());
            if (messages.size() == max) break;
            ++n2;
        }
        return messages;
    }

    public static void saveCommitHistory(String message) {
        if (message == null || message.trim().isEmpty()) {
            return;
        }
        int size = CommitMessageHistory.getCommitHistorySize();
        ArrayList<String> messages = new ArrayList<String>();
        if (size > 0) {
            messages.add(message);
            if (messages.size() < size) {
                Set<String> history = CommitMessageHistory.getCommitHistory();
                history.remove(message);
                for (String previous : history) {
                    messages.add(previous);
                    if (messages.size() == size) break;
                }
            }
        }
        CommitMessageHistory.saveMessages(messages, "commit_dialog_history_messages");
    }

    public static void saveTemplates(Collection<String> messages) {
        CommitMessageHistory.saveMessages(messages, "commit_dialog_templates");
    }

    private static void saveMessages(Collection<String> messages, String preferenceKey) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)KEY_MESSAGES);
        for (String m : messages) {
            memento.createChild(KEY_MESSAGE).putTextData(m);
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            CommitMessageHistory.getPreferenceStore().setValue(preferenceKey, writer.toString());
        }
        catch (IOException iOException) {}
    }

    private static IPreferenceStore getPreferenceStore() {
        return EclipseBazaarUI.getDefault().getPreferenceStore();
    }

    private static int getCommitHistorySize() {
        return CommitMessageHistory.getPreferenceStore().getInt("commit_dialog_history_size");
    }
}

