/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.dialogs.IgnoredFilesLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IgnoredDialog
extends Dialog {
    private Map<IResource, String> ignored;
    private TableViewer tableViewer;
    private List<IResource> unchecked;

    public IgnoredDialog(Shell parentShell, Map<IResource, String> ignored) {
        super(parentShell);
        this.setShellStyle(2160);
        this.setBlockOnOpen(true);
        this.ignored = ignored;
    }

    private void createControls(Composite container) {
        Composite control = new Composite(container, 0);
        control.setLayout((Layout)new GridLayout());
        Label label = new Label(control, 0);
        label.setText(UITexts.IgnoredDialog_label);
        int tableStyle = 68386;
        Composite tablecontainer = new Composite(container, 0);
        Table table = new Table(tablecontainer, tableStyle);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumnLayout layout = new TableColumnLayout();
        tablecontainer.setLayout((Layout)layout);
        TableColumn file = new TableColumn(table, 16384);
        file.setResizable(true);
        file.setText(UITexts.IgnoredDialog_ignoredfile);
        layout.setColumnData((Widget)file, (ColumnLayoutData)new ColumnWeightData(60, true));
        TableColumn pattern = new TableColumn(table, 16384);
        pattern.setResizable(true);
        pattern.setText(UITexts.IgnoredDialog_match);
        layout.setColumnData((Widget)pattern, (ColumnLayoutData)new ColumnWeightData(60, true));
        this.tableViewer = new CheckboxTableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Map elements = (Map)inputElement;
                return elements.entrySet().toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new IgnoredFilesLabelProvider());
        this.tableViewer.setInput(this.ignored);
        this.tableViewer.refresh(true);
        ((CheckboxTableViewer)this.tableViewer).setAllChecked(true);
        GridDataFactory gf = GridDataFactory.fillDefaults().align(4, 4).grab(true, true);
        gf.applyTo((Control)tablecontainer);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout());
        this.createControls(container);
        return container;
    }

    protected void readUnChecked() {
        ArrayList<IResource> files = new ArrayList<IResource>();
        for (Map.Entry<IResource, String> element : this.ignored.entrySet()) {
            if (((CheckboxTableViewer)this.tableViewer).getChecked(element)) continue;
            files.add(element.getKey());
        }
        this.unchecked = files;
    }

    public List<IResource> getUnChecked() {
        return this.unchecked;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(530, 500);
    }

    protected void okPressed() {
        this.readUnChecked();
        super.okPressed();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setMinimumSize(280, 400);
        IgnoredDialog dialog = new IgnoredDialog(shell, new HashMap<IResource, String>());
        dialog.setBlockOnOpen(true);
        int exit = dialog.open();
        System.out.println("exit: " + exit);
    }
}

