/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputDialog
extends TitleAreaDialog {
    private String title;
    private String message;
    private String value = "";
    private IInputValidator validator;
    private Button okButton;
    private Text text;
    private boolean inputModified;

    public InputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
        this.validator = validator;
        this.setHelpAvailable(false);
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.getTextInput() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.getText().setFocus();
        if (this.value != null) {
            this.setTextInput(this.value);
        }
    }

    protected Control createDialogArea(Composite base) {
        this.setTitle(this.title);
        Composite parent = (Composite)super.createDialogArea(base);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.setMessage(this.message);
        this.createTextInput(composite);
        InputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createTextInput(Composite composite) {
        this.text = new Text(composite, 2052);
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputDialog.this.validateInput();
            }
        });
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Control getText() {
        return this.text;
    }

    protected String getTextInput() {
        return this.text.getText();
    }

    protected void setTextInput(String text) {
        this.text.setText(text);
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            errorMessage = this.validator.isValid(this.getTextInput());
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        if (this.inputModified || this.getTextInput() != null && !this.getTextInput().isEmpty()) {
            this.inputModified = true;
            super.setErrorMessage(errorMessage);
        } else {
            super.setErrorMessage(null);
        }
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(errorMessage == null);
        }
    }
}

