/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.internal.core.model.RemoteBranch;
import org.vcs.bazaar.eclipse.ui.UITexts;
import org.vcs.bazaar.eclipse.ui.branch.BranchLocationManager;
import org.vcs.bazaar.eclipse.ui.dialogs.InputDialog;
import org.vcs.bazaar.eclipse.ui.dialogs.ShowLogDialog;
import org.vcs.bazaar.eclipse.ui.widgets.RevisionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationInputDialog
extends InputDialog {
    private Combo uriCombo;
    private Button remember;
    private Button overwrite;
    private Button force;
    private Collection<IBzrBranch> locations;
    private LocationDialogInfo info;
    private Button useExistingDir;
    private Button createBranch;
    private boolean optionRemember;
    private boolean optionOverwrite;
    private boolean optionForce;
    private boolean optionUseExistingDir;
    private boolean optionCreateBranch;
    private RevisionNumber revision;

    public static LocationInputDialog remoteBindLocationDialog(Shell parentShell, Collection<IBzrBranch> locations, IBzrBranch initialBranch, LocationDialogInfo info) {
        return LocationInputDialog.remoteLocationDialog(parentShell, locations, initialBranch, info, "Please enter the URI to bind");
    }

    public static LocationInputDialog remotePushLocationDialog(Shell parentShell, Collection<IBzrBranch> locations, IBzrBranch initialBranch, LocationDialogInfo info) {
        return LocationInputDialog.remoteLocationDialog(parentShell, locations, initialBranch, info, "Please enter the URI to push to", true, true, false, true);
    }

    public static LocationInputDialog remotePullLocationDialog(Shell parentShell, Collection<IBzrBranch> locations, IBzrBranch initialBranch, LocationDialogInfo info) {
        return LocationInputDialog.remoteLocationDialog(parentShell, locations, initialBranch, info, "Please enter the URI to pull from", true, true, false, false);
    }

    public static LocationInputDialog missingLocationDialog(Shell parentShell, Collection<IBzrBranch> locations, LocationDialogInfo info) {
        return LocationInputDialog.remoteLocationDialog(parentShell, locations, null, info, "Please enter the URI to look for missing revisions");
    }

    public static LocationInputDialog remoteLocationDialog(Shell parentShell, Collection<IBzrBranch> locations, IBzrBranch initialBranch, LocationDialogInfo info, String dialogMessage) {
        return LocationInputDialog.remoteLocationDialog(parentShell, locations, initialBranch, info, dialogMessage, false, false, false, false);
    }

    public static LocationInputDialog remoteLocationDialog(Shell parentShell, Collection<IBzrBranch> locations, IBzrBranch initialBranch, LocationDialogInfo info, String dialogMessage, boolean remember, boolean overwrite, boolean force, boolean useExistingDir) {
        return new LocationInputDialog(parentShell, "Remote Location", dialogMessage, initialBranch, new BaseURIValidator(), locations, info, remember, overwrite, force, useExistingDir, false);
    }

    public static LocationInputDialog switchLocationDialog(Shell parentShell, Collection<IBzrBranch> locations, LocationDialogInfo dialogInfo) {
        return new LocationInputDialog(parentShell, "Switch Location", "Please enter the URI to switch to", null, new BaseURIValidator(), locations, dialogInfo, false, false, true, false, true);
    }

    public LocationInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, IBzrBranch initialBranch, IInputValidator validator, Collection<IBzrBranch> locations, LocationDialogInfo info, boolean remember, boolean overwrite, boolean force, boolean useExistingDir, boolean createBranch) {
        super(parentShell, dialogTitle, dialogMessage, LocationInputDialog.getBranchString(initialBranch), validator);
        this.locations = locations;
        this.info = info;
        this.optionRemember = remember;
        this.optionOverwrite = overwrite;
        this.optionForce = force;
        this.optionUseExistingDir = useExistingDir;
        this.optionCreateBranch = createBranch;
    }

    protected static String getBranchString(IBzrBranch branch) {
        String value = "";
        if (branch != null && branch.getBranchLocation() != null) {
            value = branch.getBranchLocation().toString();
        }
        return value;
    }

    protected LocationInputDialog(Shell shell, String dialogTitle, String dialogMessage, IBzrBranch initialBranch, BaseURIValidator validator) {
        super(shell, dialogTitle, dialogMessage, LocationInputDialog.getBranchString(initialBranch), validator);
        this.locations = Collections.emptyList();
        this.info = new LocationDialogInfo();
    }

    public void loadBranchesInCombo() {
        for (IBzrBranch branch : this.locations) {
            if (branch.getBranchLocation() == null) continue;
            this.uriCombo.add(branch.getBranchLocation().toString());
        }
    }

    @Override
    protected void createTextInput(Composite composite) {
        this.uriCombo = new Combo(composite, 2052);
        this.uriCombo.setLayoutData((Object)new GridData(768));
        this.uriCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocationInputDialog.this.validateInput();
            }
        });
        this.uriCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LocationInputDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.uriCombo.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                LocationInputDialog.this.validateInput();
            }

            public void mouseDown(MouseEvent e) {
                LocationInputDialog.this.validateInput();
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.uriCombo.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                LocationInputDialog.this.validateInput();
            }

            public void focusGained(FocusEvent e) {
                LocationInputDialog.this.validateInput();
            }
        });
        this.loadBranchesInCombo();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createOptionsArea(composite);
        return composite;
    }

    protected void createOptionsArea(Composite composite) {
        if (this.optionRemember || this.optionOverwrite || this.optionForce || this.optionUseExistingDir) {
            Group checkBoxGroup = new Group(composite, 0);
            checkBoxGroup.setText(UITexts.Dialog_optionsGroup);
            checkBoxGroup.setLayout((Layout)new GridLayout(1, false));
            checkBoxGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.createOptions((Composite)checkBoxGroup);
        }
    }

    protected void createOptions(Composite composite) {
        if (this.optionRemember) {
            this.remember = new Button(composite, 32);
            this.remember.setText(UITexts.Dialog_optionRemember);
            this.remember.setSelection(false);
        }
        if (this.optionOverwrite) {
            this.overwrite = new Button(composite, 32);
            this.overwrite.setText(UITexts.Dialog_optionOverwrite);
            this.overwrite.setSelection(false);
        }
        if (this.optionForce) {
            this.force = new Button(composite, 32);
            this.force.setText(UITexts.Dialog_optionForce);
            this.force.setToolTipText(UITexts.SwitchAction_force_tooltip);
            this.force.setSelection(false);
        }
        if (this.optionUseExistingDir) {
            this.useExistingDir = new Button(composite, 32);
            this.useExistingDir.setText("Use existing directory");
            this.useExistingDir.setToolTipText("Use existing directory");
            this.useExistingDir.setSelection(false);
        }
        if (this.optionCreateBranch) {
            this.createBranch = new Button(composite, 32);
            this.createBranch.setText(UITexts.Dialog_optionCreateBranch);
            this.createBranch.setToolTipText(UITexts.Dialog_optionCreateBranchTooltip);
            this.createBranch.setSelection(false);
        }
    }

    @Override
    public Control getText() {
        return this.uriCombo;
    }

    @Override
    public String getTextInput() {
        return this.uriCombo.getText();
    }

    @Override
    public void setTextInput(String text) {
        this.uriCombo.setText(text);
    }

    protected Boolean isRemember() {
        return this.remember.getSelection();
    }

    protected Boolean isForce() {
        return this.force.getSelection();
    }

    protected boolean isRevisionSelected() {
        return this.revision.isRevisionSelected();
    }

    protected String getSelectedRevision() {
        return this.revision.getRevision();
    }

    protected void createRevisionSelector(Group revisionGroup, final boolean range) {
        this.revision = new RevisionNumber((Composite)revisionGroup);
        this.revision.addShowLogButtonSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocationInputDialog.this.showLog(range);
            }
        });
    }

    protected void showLog(boolean range) {
        ShowLogDialog dialog;
        String url = this.getTextInput();
        if (url == null || "".equals(url.trim())) {
            return;
        }
        IBzrBranch branch = BranchFactory.findOrCreateFor((String)url);
        if (branch != null && (dialog = new ShowLogDialog(this.getShell(), branch, range)).open() == 0 && dialog.getSelectedRevisionAsString() != null) {
            this.revision.setRevision(dialog.getSelectedRevisionAsString());
        }
    }

    protected void okPressed() {
        if (this.optionRemember) {
            this.info.setRemember(this.remember.getSelection());
        }
        if (this.optionOverwrite) {
            this.info.setOverwrite(this.overwrite.getSelection());
        }
        if (this.optionForce) {
            this.info.setForce(this.force.getSelection());
        }
        if (this.optionUseExistingDir) {
            this.info.setUseExistingDir(this.useExistingDir.getSelection());
        }
        if (this.optionCreateBranch) {
            this.info.setCreateBranch(this.createBranch.getSelection());
        }
        this.info.setLocation(this.getValue());
        BranchLocationManager.saveBranchLocation(this.getValue());
        super.okPressed();
    }

    public static void main(String[] args) throws BazaarClientException {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setMinimumSize(280, 400);
        LocationDialogInfo info = new LocationDialogInfo();
        ArrayList<IBzrBranch> locations = new ArrayList<IBzrBranch>();
        RemoteBranch b = new RemoteBranch(new BranchLocation("lp:bzr-eclipse"));
        locations.add((IBzrBranch)b);
        LocationInputDialog dialog = LocationInputDialog.remotePullLocationDialog(shell, locations, null, info);
        dialog.setBlockOnOpen(true);
        dialog.open();
    }

    protected static class BaseURIValidator
    implements IInputValidator {
        protected BaseURIValidator() {
        }

        public String isValid(String newText) {
            try {
                new BranchLocation(newText);
            }
            catch (BazaarClientException bazaarClientException) {
                return "Please enter a valid branch location";
            }
            return null;
        }
    }

    public static class LocationDialogInfo {
        boolean remember;
        boolean force;
        boolean useExistingDir;
        boolean overwrite;
        boolean createBranch;
        String location;

        public boolean isRemember() {
            return this.remember;
        }

        public void setRemember(boolean remember) {
            this.remember = remember;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public boolean isForce() {
            return this.force;
        }

        public void setForce(boolean force) {
            this.force = force;
        }

        public boolean isUseExistingDir() {
            return this.useExistingDir;
        }

        public void setUseExistingDir(boolean useExistingDir) {
            this.useExistingDir = useExistingDir;
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public boolean isCreateBranch() {
            return this.createBranch;
        }

        public void setCreateBranch(boolean createBranch) {
            this.createBranch = createBranch;
        }
    }
}

