/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.vcs.bazaar.eclipse.core.credentials.BazaarCredentials;
import org.vcs.bazaar.eclipse.core.credentials.SecureCredentialsStore;
import org.vcs.bazaar.eclipse.ui.UITexts;

public class LoginDialog
extends Dialog {
    private Text user;
    private Text password;
    private Button storeCheckbox;
    private BazaarCredentials credentials;
    private boolean storeInSecureStore;
    private final String location;
    private boolean isUserSet;
    private boolean passwordOnly;
    private String oldUser;

    public LoginDialog(Shell shell, String location, boolean passwordOnly) {
        super(shell);
        this.location = location;
        this.passwordOnly = passwordOnly;
        this.oldUser = SecureCredentialsStore.getUserFromLocation((String)location);
        this.isUserSet = this.oldUser != null && !this.oldUser.isEmpty();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.getShell().setText(UITexts.LoginDialog_login);
        Label locationLabel = new Label(composite, 0);
        locationLabel.setText(UITexts.LoginDialog_location);
        Text uriText = new Text(composite, 8);
        uriText.setText(this.location);
        if (!this.passwordOnly || this.isUserSet) {
            Label userLabel = new Label(composite, 0);
            userLabel.setText(UITexts.LoginDialog_user);
            this.user = this.isUserSet ? new Text(composite, 2056) : new Text(composite, 2048);
            if (this.oldUser != null) {
                this.user.setText(this.oldUser);
            }
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.user);
        }
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText(UITexts.LoginDialog_password);
        this.password = new Text(composite, 0x400800);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.password);
        Label storeLabel = new Label(composite, 0);
        storeLabel.setText(UITexts.LoginDialog_storeInSecureStore);
        this.storeCheckbox = new Button(composite, 32);
        this.storeCheckbox.setSelection(true);
        if (this.isUserSet || this.passwordOnly) {
            this.password.setFocus();
        } else {
            this.user.setFocus();
        }
        return composite;
    }

    public BazaarCredentials getCredentials() {
        return this.credentials;
    }

    public boolean getStoreInSecureStore() {
        return this.storeInSecureStore;
    }

    protected void okPressed() {
        this.credentials = new BazaarCredentials(this.user != null ? this.user.getText() : null, this.password.getText(), false);
        this.storeInSecureStore = this.storeCheckbox.getSelection();
        super.okPressed();
    }
}

